/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.discovery;

import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.api.BasicLabel;
import com.ca.apm.gaps.api.BasicMonitor;
import com.ca.apm.gaps.api.BasicMonitoringTarget;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.api.Utils;
import com.ca.apm.gaps.discovery.Discoverer;
import com.ca.apm.gaps.query.api.AgentType;
import com.ca.apm.gaps.query.api.MonitoringResourceQuery;
import com.ca.apm.gaps.query.api.ResourceData;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public abstract class AbstractDiscoverer<T extends MonitoringTarget>
implements Discoverer<T> {
    private static final Logger logger = LoggerFactory.getLogger((String)"TargetDiscovery");
    protected final String name;
    protected final String version;
    protected final TenantInfo tenant;
    protected final RestTemplate restTemplate;

    AbstractDiscoverer(String name, String version, TenantInfo tenant, RestTemplate restTemplate) {
        this.name = name;
        this.version = version;
        this.tenant = tenant;
        this.restTemplate = restTemplate;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    public TenantInfo getTenant() {
        return this.tenant;
    }

    protected boolean isContainerResource(ResourceData resource) {
        if (resource.getAttributeValue("containerId").isPresent()) {
            return true;
        }
        return resource.getAttributeValue("Host:Container ID").isPresent();
    }

    protected Optional<MonitoringTarget> createProcessTargetForAgent(ResourceData resource) {
        String agentId = resource.getAgentId().get();
        Optional<String> type = resource.getAttributeValue("agentType");
        AgentType agentType = AgentType.UNKNOWN;
        if (type.isPresent()) {
            try {
                agentType = AgentType.valueOf(type.get().toUpperCase());
            }
            catch (IllegalArgumentException e) {
                logger.debug(e.getMessage(), (Throwable)e);
            }
        }
        if (agentType.equals((Object)AgentType.UNKNOWN)) {
            return Optional.empty();
        }
        String processName = agentType.toString();
        BasicMonitoringTarget process = new BasicMonitoringTarget(processName, MonitoringTarget.MonitoringTargetType.PROCESS);
        if (!agentType.equals((Object)AgentType.INFRASTRUCTURE)) {
            process.addLabel(BasicLabel.of((String)"runtime", (String)processName));
            BasicMonitor monitor = new BasicMonitor(Utils.createId((String)"monitor", (String)agentId), (Object)((Object)agentType) + " agent", (Object)((Object)agentType) + "_agent");
            monitor.addLabel(BasicLabel.of((String)"agentId", (String)agentId));
            monitor.addLabel(BasicLabel.of((String)"agentType", (String)processName));
            process.getMyMonitors().add(monitor);
        }
        return Optional.of(process);
    }

    protected Optional<ResourceData> getAgentData(String agentName) {
        MonitoringResourceQuery.Builder queryBuilder = new MonitoringResourceQuery.Builder(this.tenant, this.restTemplate);
        MonitoringResourceQuery query = queryBuilder.findAgentWithName(agentName).build();
        Optional<List<ResourceData>> resources = query.execute();
        return resources.isPresent() && !resources.get().isEmpty() ? Optional.of(resources.get().get(0)) : Optional.empty();
    }

    protected boolean isAgentAlive(String agentName) {
        return this.getAgentData(agentName).isPresent();
    }

    public String toString() {
        return "DiscoveryPlugin [name=" + this.name + ", version=" + this.version + "]";
    }
}

