/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.discovery;

import com.ca.apm.gaps.Utils;
import com.ca.apm.gaps.api.BasicLabel;
import com.ca.apm.gaps.api.BasicMonitor;
import com.ca.apm.gaps.api.BasicMonitoringTarget;
import com.ca.apm.gaps.api.Container;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ContainerMetricDeserializer
extends TypeAdapter<Set<Container>> {
    private static final Logger logger = LoggerFactory.getLogger(ContainerMetricDeserializer.class);

    public void write(JsonWriter out, Set<Container> value) throws IOException {
    }

    public Set<Container> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        HashSet<Container> containers = new HashSet<Container>();
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (!name.equals("metrics")) continue;
            try {
                this.readMetrics(in, containers);
            }
            catch (Exception e) {
                logger.debug("error while reading metrics", (Throwable)e);
            }
        }
        in.endObject();
        return containers;
    }

    private void readMetrics(JsonReader in, Set<Container> containers) throws IOException {
        in.beginArray();
        while (in.hasNext()) {
            try {
                this.readAttributeMetric(in, containers);
            }
            catch (Exception e) {
                logger.debug("error while reading metrics", (Throwable)e);
            }
        }
        in.endArray();
    }

    private void readAttributeMetric(JsonReader in, Set<Container> containers) throws IOException {
        BasicMonitoringTarget process = null;
        String containerId = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals("source")) {
                String domainPrefix;
                String agentId = in.nextString();
                if (agentId.startsWith(domainPrefix = "SuperDomain|")) {
                    agentId = agentId.substring(domainPrefix.length());
                }
                process = new BasicMonitoringTarget();
                process.setName("process");
                process.setType(MonitoringTarget.MonitoringTargetType.PROCESS);
                process.setId(com.ca.apm.gaps.api.Utils.createId((MonitoringTarget.MonitoringTargetType)MonitoringTarget.MonitoringTargetType.PROCESS, (String)"0"));
                BasicMonitor javaAgent = new BasicMonitor();
                javaAgent.setName("agent");
                javaAgent.setId(com.ca.apm.gaps.api.Utils.createId((String)"monitor", (String)agentId));
                javaAgent.getLabels().add(BasicLabel.of((String)"agentId", (String)agentId));
                process.getMyMonitors().add(javaAgent);
                continue;
            }
            if (name.equals("values")) {
                containerId = this.readValues(in);
                continue;
            }
            in.skipValue();
        }
        if (Utils.isValid(containerId) && process != null) {
            Container container = new Container(containerId);
            container.getLabels().add(BasicLabel.of((String)"containerId", (String)containerId));
            process.setParentId(containerId);
            container.getChildTargets().add(process);
            containers.add(container);
        }
        in.endObject();
    }

    private String readValues(JsonReader in) throws IOException {
        String containerId = null;
        in.beginArray();
        while (in.hasNext()) {
            in.beginArray();
            int i = 0;
            while (in.hasNext()) {
                if (i++ == 4) {
                    containerId = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            in.endArray();
        }
        in.endArray();
        return containerId;
    }
}

