/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.discovery;

import com.ca.apm.gaps.MonitoringBundles;
import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.api.BasicLabel;
import com.ca.apm.gaps.api.BasicMonitor;
import com.ca.apm.gaps.api.Host;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.ca.apm.gaps.api.Utils;
import com.ca.apm.gaps.discovery.AbstractDiscoverer;
import com.ca.apm.gaps.query.api.AgentType;
import com.ca.apm.gaps.query.api.MonitoringResourceQuery;
import com.ca.apm.gaps.query.api.ResourceData;
import com.google.gson.Gson;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.client.RestTemplate;

public class HostDiscoverer
extends AbstractDiscoverer<Host> {
    private static final Logger logger = LoggerFactory.getLogger(HostDiscoverer.class);

    HostDiscoverer(TenantInfo tenant, RestTemplate restTemplate) {
        this("Host And HostMonitor Discovery", "1.0", tenant, restTemplate);
    }

    HostDiscoverer(String name, String version, TenantInfo tenant, RestTemplate restTemplate) {
        super(name, version, tenant, restTemplate);
    }

    @Override
    public Set<Host> discover() {
        logger.debug("Running host discovery");
        MonitoringResourceQuery monitoredHostQuery = new MonitoringResourceQuery.Builder(this.tenant, this.restTemplate).findHosts().reportAgentName().build();
        Optional<List<ResourceData>> monitoredHostResources = monitoredHostQuery.execute();
        HashMap<String, List> monitoredHosts = new HashMap<String, List>();
        if (monitoredHostResources.isPresent()) {
            for (ResourceData r : monitoredHostResources.get()) {
                if (!this.isHostAgentsAlive(r.getAgentId().get()) || !r.getSimpleHostName().isPresent()) continue;
                monitoredHosts.computeIfAbsent(r.getSimpleHostName().get(), k -> new ArrayList()).add(r.getAgentId().get());
            }
        }
        MonitoringResourceQuery.Builder queryBuilder = new MonitoringResourceQuery.Builder(this.tenant, this.restTemplate);
        MonitoringResourceQuery query = queryBuilder.findAgents().reportHostName().reportAttribute("Host:Container ID").build();
        Optional<List<ResourceData>> allHostResources = query.execute();
        HashMap<String, Host> hostTargets = new HashMap<String, Host>();
        if (allHostResources.isPresent()) {
            for (ResourceData resource : allHostResources.get()) {
                if (this.isContainerResource(resource)) continue;
                Host host = hostTargets.computeIfAbsent(resource.getSimpleHostName().get(), name -> new Host(name));
                host.addLabel(BasicLabel.of((String)"hostname", resource.getHostName()));
                host.addLabel(BasicLabel.of((String)"externalId", resource.getExternalId()));
                if (resource.getAgentId().isPresent()) {
                    Optional<MonitoringTarget> child = this.createProcessTargetForAgent(resource);
                    child.ifPresent(childTarget -> host.getChildTargets().add(childTarget));
                }
                if (!monitoredHosts.containsKey(host.getHostName())) continue;
                host.getMyMonitors().add(new BasicMonitor(Utils.createId((String)"monitor", (String)host.getHostName()), "Host Monitor", MonitoringBundles.HOST_MONITOR.getId()));
            }
        }
        return new HashSet<Host>(hostTargets.values());
    }

    protected boolean isHostAgentsAlive(String agentName) {
        String prefix = "$JSON{";
        if (agentName.startsWith(prefix)) {
            agentName = agentName.substring(prefix.length(), agentName.length() - 1);
            for (String name : (String[])new Gson().fromJson(agentName, String[].class)) {
                if (!this.isAgentAlive(name)) continue;
                return true;
            }
            return false;
        }
        return this.isAgentAlive(agentName);
    }

    @Override
    protected boolean isAgentAlive(String agentName) {
        MonitoringResourceQuery.Builder queryBuilder = new MonitoringResourceQuery.Builder(this.tenant, this.restTemplate);
        MonitoringResourceQuery query = queryBuilder.findAgentWithName(agentName).hasAttribute("agentType", AgentType.INFRASTRUCTURE.toString()).build();
        Optional<List<ResourceData>> resources = query.execute();
        return resources.isPresent() && !resources.get().isEmpty();
    }

    @Override
    public String toString() {
        try {
            return "HostDiscovery [tenantId=" + this.tenant.getTenantId() + ", name=" + this.getName() + ", version=" + this.getVersion() + "]";
        }
        catch (Exception e) {
            return "HostDiscovery [tenantId=N/A, name=" + this.getName() + ", version=" + this.getVersion() + "]";
        }
    }
}

