/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.notifications;

import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.notifications.GapChangeEvent;
import com.ca.apm.gaps.notifications.GapEventStore;
import com.ca.apm.gaps.notifications.Publisher;
import com.ca.apm.gaps.query.api.MonitoringResourceQuery;
import com.ca.apm.gaps.query.api.ResourceData;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

class AtcVertexGapsPublisher
implements Publisher {
    private final GapEventStore gapEventStore;
    protected Logger logger = LoggerFactory.getLogger(AtcVertexGapsPublisher.class);
    private static final String VERTEX_URL_UNFORMATTED = "%s/%s/tas/vertex/custom";
    protected static final String AGENT_VERTEX_GAPS_ATTRIBUTE = "MonitoringGaps";
    protected static final String AGENT_VERTEX_ID_ATTRIBUTE = "id";
    protected final TenantInfo tenant;
    protected final String vertexUrl;
    protected final MultiValueMap<String, String> headers;
    protected final EventsToPayloadConvertor<?> eventsToPayloadConvertor;

    public AtcVertexGapsPublisher(GapEventStore gapEventStore, TenantInfo tenant) {
        this(gapEventStore, tenant, String.format(VERTEX_URL_UNFORMATTED, tenant.getAgentManagerUrl(), tenant.getTenantId()));
    }

    public AtcVertexGapsPublisher(GapEventStore gapEventStore, TenantInfo tenant, String vertexUrl) {
        this.gapEventStore = gapEventStore;
        this.tenant = tenant;
        this.vertexUrl = vertexUrl;
        this.headers = new LinkedMultiValueMap();
        this.headers.add((Object)"Content-Type", (Object)"application/json");
        this.headers.add((Object)"Authorization", (Object)("Bearer " + tenant.getPublicApiToken()));
        this.headers.add((Object)"Connection", (Object)"close");
        boolean setGapsAsArray = true;
        this.eventsToPayloadConvertor = setGapsAsArray ? new EventsToPayloadConvertor<List<String>>(){

            @Override
            public List<String> toValue(List<String> gaps) {
                return gaps;
            }
        } : new EventsToPayloadConvertor<String>(){

            @Override
            public String toValue(List<String> gaps) {
                return this.toSimpleListString(gaps);
            }

            private <E> String toSimpleListString(List<E> list) {
                Iterator<E> it = list.iterator();
                if (!it.hasNext()) {
                    return "[]";
                }
                StringBuilder sb = new StringBuilder();
                while (true) {
                    E e;
                    sb.append((Object)((e = it.next()) == list ? "(this Collection)" : e));
                    if (!it.hasNext()) {
                        return sb.toString();
                    }
                    sb.append(',').append(' ');
                }
            }
        };
        this.logger.debug("http headers: {}", this.headers);
        this.logger.debug("atc vertex url: {}", (Object)vertexUrl);
    }

    @Override
    public void publish(List<GapChangeEvent> events) {
        Optional<String> payload = this.eventsToPayloadConvertor.createPayload(events);
        if (payload.isPresent()) {
            this.sendNotifications(payload.get());
        }
    }

    protected void sendNotifications(String jsonPayload) {
        this.logger.debug("Making request to {} for DXAPM atc agent vertex with payload {}", (Object)this.vertexUrl, (Object)jsonPayload);
        try {
            HttpEntity entity = new HttpEntity((Object)jsonPayload, this.headers);
            ResponseEntity response = this.gapEventStore.restTemplate.exchange(this.vertexUrl, HttpMethod.PUT, entity, String.class, new Object[0]);
            this.logger.debug(response.getStatusCode().toString());
        }
        catch (Exception e) {
            this.logger.error("DXAPM APM Vertex request failed: " + e.getMessage());
            this.logger.debug(e.getMessage(), (Throwable)e);
        }
    }

    protected Optional<ResourceData> getAgentData(TenantInfo tenant, String agentName) {
        MonitoringResourceQuery.Builder queryBuilder = new MonitoringResourceQuery.Builder(tenant, this.gapEventStore.restTemplate);
        MonitoringResourceQuery query = queryBuilder.findAgentWithName(agentName).build();
        Optional<List<ResourceData>> resources = query.execute();
        return resources.isPresent() && !resources.get().isEmpty() ? Optional.of(resources.get().get(0)) : Optional.empty();
    }

    protected class VertexWithCustomAttributes<T> {
        private final String id;
        private final Map<String, T> attributes;

        public VertexWithCustomAttributes(String vertexId) {
            this(vertexId, new HashMap());
        }

        public VertexWithCustomAttributes(String vertexId, Map<String, T> attributes) {
            this.id = vertexId;
            this.attributes = attributes;
        }

        public void add(String attributeName, T attributeValue) {
            this.attributes.put(attributeName, attributeValue);
        }
    }

    protected abstract class EventsToPayloadConvertor<T> {
        protected EventsToPayloadConvertor() {
        }

        public Optional<String> createPayload(List<GapChangeEvent> events) {
            List<VertexWithCustomAttributes<T>> vertices = this.createVerticesWithGapsAttribute(events);
            return vertices.isEmpty() ? Optional.empty() : Optional.of(((AtcVertexGapsPublisher)AtcVertexGapsPublisher.this).gapEventStore.gson.toJson(Collections.singletonMap("vertices", vertices)));
        }

        public List<VertexWithCustomAttributes<T>> createVerticesWithGapsAttribute(List<GapChangeEvent> events) {
            ArrayList vertices = new ArrayList();
            for (GapChangeEvent event : events) {
                this.createVertexWithGapsAttribute(event).ifPresent(v -> vertices.add((VertexWithCustomAttributes)v));
            }
            return vertices;
        }

        protected Optional<VertexWithCustomAttributes<T>> createVertexWithGapsAttribute(GapChangeEvent event) {
            String agentId = event.getLabel("agentId").get().getValue();
            Optional<ResourceData> agentInfo = AtcVertexGapsPublisher.this.getAgentData(AtcVertexGapsPublisher.this.tenant, agentId);
            if (agentInfo.isPresent() && agentInfo.get().getAttributeValue(AtcVertexGapsPublisher.AGENT_VERTEX_ID_ATTRIBUTE).isPresent()) {
                String agentVertexId = agentInfo.get().getAttributeValue(AtcVertexGapsPublisher.AGENT_VERTEX_ID_ATTRIBUTE).get();
                List<String> gaps = ((AtcVertexGapsPublisher)AtcVertexGapsPublisher.this).gapEventStore.gapsController.getAgentGapsAsList(event.getTenantId(), agentId, false).stream().map(bundle -> bundle.getName()).collect(Collectors.toList());
                VertexWithCustomAttributes<T> agentVertex = new VertexWithCustomAttributes<T>(agentVertexId);
                agentVertex.add(AtcVertexGapsPublisher.AGENT_VERTEX_GAPS_ATTRIBUTE, this.toValue(gaps));
                return Optional.of(agentVertex);
            }
            return Optional.empty();
        }

        public abstract T toValue(List<String> var1);
    }
}

