/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.notifications;

import com.ca.apm.gaps.GapsConfiguration;
import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.TenantsAdmin;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.controllers.MonitoringGapsController;
import com.ca.apm.gaps.notifications.AtcVertexGapsPublisher;
import com.ca.apm.gaps.notifications.GapChangeEvent;
import com.ca.apm.gaps.notifications.GapChangeListener;
import com.ca.apm.gaps.notifications.JarvisApmEventPublisher;
import com.ca.apm.gaps.notifications.Publisher;
import com.google.gson.Gson;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class GapEventStore
implements GapChangeListener {
    private static final Logger logger = LoggerFactory.getLogger(GapEventStore.class);
    static final SimpleDateFormat DATE_TIME_FORMATTER = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    private final Map<String, Queue<GapChangeEvent>> notificationQueue = new ConcurrentHashMap<String, Queue<GapChangeEvent>>();
    private final Map<String, AgentGapPublishingTask> tasks = new ConcurrentHashMap<String, AgentGapPublishingTask>();
    @Autowired
    Gson gson;
    @Autowired
    private TenantsAdmin tenantDetails;
    @Autowired
    MonitoringGapsController gapsController;
    @Autowired
    RestTemplate restTemplate;
    @Autowired
    private GapsConfiguration config;
    private static final Publisher noopPublisher = new NoopPublisher();

    @Override
    public void notify(GapChangeEvent event) {
        logger.debug("Received GapChangeEvent: {}", (Object)event);
        Optional<Label> agentId = event.getLabel("agentId");
        if (agentId.isPresent()) {
            Queue queue = this.notificationQueue.computeIfAbsent(event.getTenantId(), k -> new ConcurrentLinkedQueue());
            queue.add(event);
            this.tasks.computeIfAbsent(event.getTenantId(), k -> new AgentGapPublishingTask(this, this.tenantDetails.getTenantWithId(event.getTenantId()).get(), queue));
        }
    }

    @Scheduled(fixedRateString="${gaps.notifications.frequency:15000}")
    private void discover() {
        logger.debug("Running monitoring gap publishing task");
        for (Map.Entry<String, AgentGapPublishingTask> taskEntry : this.tasks.entrySet()) {
            taskEntry.getValue().sendNotification();
        }
    }

    class AgentGapPublishingTask {
        private final Queue<GapChangeEvent> eventQueue;
        private final List<Publisher> publishers = new ArrayList<Publisher>(2);
        private final GapEventStore gapEventStore;

        public AgentGapPublishingTask(GapEventStore gapEventStore, TenantInfo tenant, Queue<GapChangeEvent> eventQueue) {
            this.gapEventStore = gapEventStore;
            if (((GapEventStore)GapEventStore.this).config.elasticStoreIngestionEnabled) {
                this.publishers.add(new JarvisApmEventPublisher(gapEventStore, tenant));
            }
            if (((GapEventStore)GapEventStore.this).config.atcVertexUpdateEnabled) {
                this.publishers.add(new AtcVertexGapsPublisher(gapEventStore, tenant));
            }
            this.eventQueue = eventQueue;
        }

        public void sendNotification() {
            ArrayList<GapChangeEvent> snapshot = new ArrayList<GapChangeEvent>();
            while (!this.eventQueue.isEmpty()) {
                snapshot.add(this.eventQueue.poll());
            }
            if (!snapshot.isEmpty()) {
                for (Publisher publisher : this.publishers) {
                    publisher.publish(snapshot);
                }
            }
        }
    }

    private static class NoopPublisher
    implements Publisher {
        private NoopPublisher() {
        }

        @Override
        public void publish(List<GapChangeEvent> events) {
        }
    }
}

