/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.notifications;

import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.Utils;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.notifications.Body;
import com.ca.apm.gaps.notifications.Document;
import com.ca.apm.gaps.notifications.GapChangeEvent;
import com.ca.apm.gaps.notifications.GapEventStore;
import com.ca.apm.gaps.notifications.Header;
import com.ca.apm.gaps.notifications.NotificationPayload;
import com.ca.apm.gaps.notifications.Publisher;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;

class JarvisApmEventPublisher
implements Publisher {
    private final GapEventStore gapEventStore;
    private final Logger logger = LoggerFactory.getLogger(JarvisApmEventPublisher.class);
    private static final String GAPS_MESSAGE_UNFORMATTED = "List of missing bundles: %s";
    private static final String HEADER_PRODUCT_ID = "ao";
    private static final String HEADER_DOC_TYPE_ID = "itoa_events_apm";
    private static final String HEADER_DOC_TYPE_VERSION = "1";
    private static final String INGESTION_PATH = "/jarvis/v2/ingestion";
    private static final String INGESTION_URL_PROTOCOL = "https://";
    private static final String PRODUCT_ID = "apm_monitoring_gaps";
    private static final String PRODUCT_VERSION = "1.0";
    private final String ingestionUrl;
    private final Header docHeader;
    private final HttpHeaders headers;
    private Base64.Encoder encoder = Base64.getEncoder();

    public JarvisApmEventPublisher(GapEventStore gapEventStore, TenantInfo tenant) {
        this.gapEventStore = gapEventStore;
        this.ingestionUrl = String.format("%s%s%s", INGESTION_URL_PROTOCOL, Utils.getAPMGatewayFromURL(tenant.getAgentManagerUrl()), INGESTION_PATH);
        this.docHeader = Header.of(tenant.getCohortId(), HEADER_PRODUCT_ID, HEADER_DOC_TYPE_ID, HEADER_DOC_TYPE_VERSION, "$['event_unique_id']");
        this.headers = new HttpHeaders();
        this.headers.setContentType(MediaType.APPLICATION_JSON);
        this.headers.set("Authorization", "Bearer " + tenant.getPublicApiToken());
        this.headers.set("index_name", String.format("%s_%s_%s", HEADER_PRODUCT_ID, HEADER_DOC_TYPE_ID, HEADER_DOC_TYPE_VERSION));
        this.headers.add("Connection", "close");
        this.logger.debug("document header: {}", (Object)this.docHeader);
        this.logger.debug("http headers: {}", (Object)this.headers);
        this.logger.debug("elastic store ingestion url: {}", (Object)this.ingestionUrl);
    }

    @Override
    public void publish(List<GapChangeEvent> events) {
        ArrayList<Body> notifications = new ArrayList<Body>();
        for (GapChangeEvent event : events) {
            notifications.add(this.createNotification(event));
        }
        if (!notifications.isEmpty()) {
            this.sendNotification(notifications);
        }
    }

    private Body createNotification(GapChangeEvent event) {
        String currentTimestamp = GapEventStore.DATE_TIME_FORMATTER.format(new Date());
        String agentId = event.getLabel("agentId").get().getValue();
        Optional<Label> containerId = event.getLabel("containerId");
        Optional<Label> externalId = event.getLabel("externalId");
        Optional<Label> hostName = event.getLabel("hostname");
        List gaps = this.gapEventStore.gapsController.getAgentGapsAsList(event.getTenantId(), agentId, false).stream().map(bundle -> bundle.getName()).collect(Collectors.toList());
        Body notification = new Body();
        notification.setAgentId(agentId);
        notification.setEvent_unique_id(this.generateNewEventId());
        notification.setMessage(String.format(GAPS_MESSAGE_UNFORMATTED, gaps.toString()));
        notification.setProduct(PRODUCT_ID);
        notification.setProduct_version(PRODUCT_VERSION);
        notification.setStartTime(currentTimestamp);
        notification.setTimestamp(currentTimestamp);
        if (containerId.isPresent()) {
            notification.setContainerId(containerId.get().getValue());
        }
        if (hostName.isPresent()) {
            notification.setHostName(hostName.get().getValue());
        }
        if (externalId.isPresent()) {
            notification.setExternalId(externalId.get().getValue());
        }
        return notification;
    }

    private void sendNotification(List<Body> notifications) {
        HttpEntity entity;
        ResponseEntity response;
        this.logger.info("Sending gap notifications to elastic store: {}", notifications);
        Document doc = new Document();
        doc.setHeader(this.docHeader);
        doc.setBody(notifications);
        NotificationPayload payload = new NotificationPayload();
        payload.setDocuments(Arrays.asList(doc));
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("Making ingest request to {}  with payload: {}", (Object)this.ingestionUrl, (Object)this.gapEventStore.gson.toJson((Object)payload));
        }
        if ((response = this.gapEventStore.restTemplate.postForEntity(this.ingestionUrl, (Object)(entity = new HttpEntity((Object)payload, (MultiValueMap)this.headers)), String.class, new Object[0])).getStatusCode().isError()) {
            this.logger.error("Ingestion Failed with message : " + response.getStatusCode().toString());
        } else {
            this.logger.info("Ingested notifications successfully to event store. response status:  {}", (Object)response.getStatusCode());
        }
    }

    private String generateNewEventId() {
        UUID id = UUID.randomUUID();
        byte[] bytes = this.encoder.encode(id.toString().getBytes());
        return new String(bytes, StandardCharsets.UTF_8);
    }
}

