/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.query.api;

import com.ca.apm.gaps.Utils;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AgentMetricDeserializer
extends TypeAdapter<Map<String, Map<String, String>>> {
    private static final Logger logger = LoggerFactory.getLogger(AgentMetricDeserializer.class);

    public void write(JsonWriter out, Map<String, Map<String, String>> value) throws IOException {
    }

    public Map<String, Map<String, String>> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        HashMap<String, Map<String, String>> agentToMetricsMap = new HashMap<String, Map<String, String>>();
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (!name.equals("metrics")) continue;
            try {
                this.readMetrics(in, agentToMetricsMap);
            }
            catch (Exception e) {
                logger.debug("error while reading metrics", (Throwable)e);
            }
        }
        in.endObject();
        return agentToMetricsMap;
    }

    private void readMetrics(JsonReader in, Map<String, Map<String, String>> agentToMetricsMap) throws IOException {
        in.beginArray();
        while (in.hasNext()) {
            try {
                this.readAttributeMetric(in, agentToMetricsMap);
            }
            catch (Exception e) {
                logger.debug("error while reading metrics", (Throwable)e);
            }
        }
        in.endArray();
    }

    private void readAttributeMetric(JsonReader in, Map<String, Map<String, String>> agentToMetricsMap) throws IOException {
        String agentId = null;
        String metricPath = null;
        String metricValue = null;
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals("source")) {
                String domainPrefix;
                agentId = in.nextString();
                if (!agentId.startsWith(domainPrefix = "SuperDomain|")) continue;
                agentId = agentId.substring(domainPrefix.length());
                continue;
            }
            if (name.equals("attribute")) {
                metricPath = in.nextString();
                continue;
            }
            if (name.equals("values")) {
                metricValue = this.readValues(in);
                continue;
            }
            in.skipValue();
        }
        if (Utils.isValid(agentId) && Utils.isValid(metricPath) && Utils.isValid(metricValue)) {
            agentToMetricsMap.computeIfAbsent(agentId, k -> new HashMap()).put(metricPath, metricValue);
        }
        in.endObject();
    }

    private String readValues(JsonReader in) throws IOException {
        String latestValue = null;
        in.beginArray();
        while (in.hasNext()) {
            in.beginArray();
            int i = 0;
            while (in.hasNext()) {
                if (i++ == 4) {
                    latestValue = in.nextString();
                    continue;
                }
                in.skipValue();
            }
            in.endArray();
        }
        in.endArray();
        return latestValue;
    }
}

