/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.query.api;

import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.api.Container;
import com.ca.apm.gaps.query.api.AtcGraphDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class AtcGraphQuery {
    private static final Logger logger = LoggerFactory.getLogger(AtcGraphQuery.class);
    private static final String CONTAINER_QUERY_URL_UNFORMATTED = "%s/%s/apm/atc/api/vertex?q=(%s)";
    private static final String ATTRIBUTE_SERIALIZE_UNFORMATTED = "%s:%s";
    private static final String ATTRIBUTE_CONCAT_TOKEN = " AND ";
    private String authToken;
    private String graphUrl;
    private final Gson gson;
    private static Type collectionType = new TypeToken<Set<Container>>(){}.getType();
    private final RestTemplate restTemplate;
    private MultiValueMap<String, String> headers;

    AtcGraphQuery(TenantInfo tenant, RestTemplate restTemplate, String layer, String attrbuteName, String attrbuteValue) {
        this(tenant, restTemplate, layer, Collections.singletonMap(attrbuteName, attrbuteValue));
    }

    AtcGraphQuery(TenantInfo tenant, RestTemplate restTemplate, String layer, Map<String, String> attributesToMatch) {
        this.restTemplate = restTemplate;
        this.authToken = "Bearer " + tenant.getPublicApiToken();
        this.graphUrl = String.format(CONTAINER_QUERY_URL_UNFORMATTED, tenant.getAgentManagerUrl(), tenant.getTenantId(), this.serialize(attributesToMatch));
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(collectionType, (Object)new AtcGraphDeserializer());
        this.gson = gsonBuilder.create();
        this.headers = new LinkedMultiValueMap();
        this.headers.add((Object)"Content-Type", (Object)"application/json");
        this.headers.add((Object)"Authorization", (Object)this.authToken);
        this.headers.add((Object)"Connection", (Object)"close");
    }

    public Optional<List<Map<String, String>>> execute() {
        logger.debug("DXAPM atc graph query {}", (Object)this.graphUrl);
        HttpEntity entity = new HttpEntity(this.headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.graphUrl, HttpMethod.GET, entity, String.class, new Object[0]);
            logger.debug("DXAPM atc graph query response : {}", response.getBody());
            List attributeBags = (List)this.gson.fromJson((String)response.getBody(), collectionType);
            return attributeBags.isEmpty() ? Optional.empty() : Optional.of(attributeBags);
        }
        catch (Exception e) {
            logger.error("DXAPM atc graph query failed: " + e.getMessage());
            logger.debug(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    private String serialize(Map<String, String> attributes) {
        StringBuilder builder = new StringBuilder();
        if (!attributes.isEmpty()) {
            Iterator<Map.Entry<String, String>> iter = attributes.entrySet().iterator();
            Map.Entry<String, String> entry = iter.next();
            builder.append(String.format(ATTRIBUTE_SERIALIZE_UNFORMATTED, entry.getKey(), AtcGraphQuery.escapeSpecialChars(entry.getValue())));
            while (iter.hasNext()) {
                builder.append(ATTRIBUTE_CONCAT_TOKEN);
                entry = iter.next();
                builder.append(String.format(ATTRIBUTE_SERIALIZE_UNFORMATTED, entry.getKey(), AtcGraphQuery.escapeSpecialChars(entry.getValue())));
            }
        }
        return builder.toString();
    }

    public static String escapeSpecialChars(String value) {
        return AtcGraphQuery.escapeSpecialCharsSimple(value);
    }

    private static String escapeSpecialCharsSimple(String value) {
        String[] specials;
        for (String ch : specials = new String[]{"+", "-", " "}) {
            value = value.replace(ch, "\\" + ch);
        }
        return value;
    }
}

