/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.query.api;

import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.query.api.AgentMetricDeserializer;
import com.ca.apm.gaps.query.api.QueryData;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class MetricQuery {
    private static final Logger logger = LoggerFactory.getLogger(MetricQuery.class);
    private static final String CONTAINER_QUERY_URL_UNFORMATTED = "%s/metrics/queryMetric";
    private String authToken;
    private String metricQueryUrl;
    private final Gson gson;
    private static Type collectionType = new TypeToken<Map<String, Map<String, String>>>(){}.getType();
    private final RestTemplate restTemplate;
    private MultiValueMap<String, String> headers;
    private final String queryData;

    public MetricQuery(RestTemplate restTemplate, TenantInfo tenant, String metricName) {
        this(restTemplate, tenant, new QueryData.Builder().addMetricName(metricName).build());
    }

    public MetricQuery(RestTemplate restTemplate, TenantInfo tenant, String agentName, String metricName) {
        this(restTemplate, tenant, agentName, Arrays.asList(metricName));
    }

    public MetricQuery(RestTemplate restTemplate, TenantInfo tenant, String agentName, List<String> agentMetrics) {
        this(restTemplate, tenant, new QueryData.Builder().addAgentName(agentName).addMetricNames(agentMetrics).build());
    }

    public MetricQuery(RestTemplate restTemplate, TenantInfo tenant, QueryData query) {
        this.restTemplate = restTemplate;
        this.metricQueryUrl = String.format(CONTAINER_QUERY_URL_UNFORMATTED, tenant.getAgentManagerUrl());
        this.authToken = "Bearer " + tenant.getPublicApiToken();
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(collectionType, (Object)new AgentMetricDeserializer());
        this.gson = gsonBuilder.create();
        this.queryData = this.gson.toJson((Object)query);
        this.headers = new LinkedMultiValueMap();
        this.headers.add((Object)"Content-Type", (Object)"application/json;charset=UTF-8");
        this.headers.add((Object)"Authorization", (Object)this.authToken);
        this.headers.add((Object)"Connection", (Object)"close");
    }

    public Optional<Map<String, Map<String, String>>> execute() {
        try {
            logger.debug("Metric query payload: {}", (Object)this.queryData);
            HttpEntity entity = new HttpEntity((Object)this.queryData, this.headers);
            ResponseEntity response = this.restTemplate.postForEntity(this.metricQueryUrl, (Object)entity, String.class, new Object[0]);
            logger.debug("Metric query response : {}", response.getBody());
            Map attributeBags = (Map)this.gson.fromJson((String)response.getBody(), collectionType);
            return attributeBags.isEmpty() ? Optional.empty() : Optional.of(attributeBags);
        }
        catch (Exception e) {
            logger.error("DXAPM Metric query failed: " + e.getMessage());
            logger.debug(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public String toString() {
        return "MetricQuery [queryData=" + this.queryData + "]";
    }
}

