/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.query.api;

import java.util.ArrayList;
import java.util.List;

public class QueryData {
    private QuerySpecifier querySpecifier;
    private QueryRange queryRange;
    private int clampSize;

    private QueryData(Builder builder) {
        Specifier agentSpecifier = !builder.agentNames.isEmpty() ? new ExactNameSpecifier(builder.agentNames.toArray(new String[0])) : new RegexPatternSpecifier(builder.agentRegex);
        Specifier metricSpecifier = !builder.metricNames.isEmpty() ? new ExactNameSpecifier(builder.metricNames.toArray(new String[0])) : new RegexPatternSpecifier(builder.metricRegex);
        this.querySpecifier = new QuerySpecifier(agentSpecifier, metricSpecifier);
        this.queryRange = new QueryRange(builder.endTime);
        this.clampSize = builder.clampSize;
    }

    public static class Builder {
        private String agentRegex = ".*";
        private List<String> agentNames;
        private String metricRegex = ".*";
        private List<String> metricNames;
        private int clampSize = 10000;
        private long endTime = System.currentTimeMillis() / 1000L;

        public Builder() {
            this.agentNames = new ArrayList<String>();
            this.metricNames = new ArrayList<String>();
        }

        public Builder setAgentRegex(String agentRegex) {
            this.agentRegex = agentRegex;
            return this;
        }

        public Builder addAgentName(String agentName) {
            agentName = agentName.startsWith("SuperDomain|") ? agentName : "SuperDomain|" + agentName;
            this.agentNames.add(agentName);
            return this;
        }

        public Builder setMetricRegex(String metricRegex) {
            this.metricRegex = metricRegex;
            return this;
        }

        public Builder addMetricName(String name) {
            this.metricNames.add(name);
            return this;
        }

        public Builder addMetricNames(List<String> names) {
            this.metricNames.addAll(names);
            return this;
        }

        public Builder setClampSize(int value) {
            this.clampSize = value;
            return this;
        }

        public Builder setEndTime(long value) {
            this.endTime = value;
            return this;
        }

        public QueryData build() {
            return new QueryData(this);
        }
    }

    private class QueryRange {
        private long endTime;
        private long rangeSize;
        private long frequency;

        public QueryRange(long endTime) {
            this(endTime, 30L, 15L);
        }

        public QueryRange(long endTime, long rangeSize, long frequency) {
            this.endTime = endTime;
            this.rangeSize = rangeSize;
            this.frequency = frequency;
        }
    }

    private class QuerySpecifier {
        private String op = "SPEC";
        private Specifier sourceNameSpecifier;
        private Specifier attributeNameSpecifier;

        QuerySpecifier(Specifier sourceNameSpecifier, Specifier attributeNameSpecifier) {
            this.sourceNameSpecifier = sourceNameSpecifier;
            this.attributeNameSpecifier = attributeNameSpecifier;
        }
    }

    private class RegexPatternSpecifier
    extends Specifier {
        private String pattern;

        RegexPatternSpecifier(String pattern) {
            this.op = "REGEX";
            this.pattern = pattern;
        }
    }

    private class ExactNameSpecifier
    extends Specifier {
        private String[] names;

        ExactNameSpecifier(String[] names) {
            this.op = "EXACT";
            this.names = names;
        }
    }

    private abstract class Specifier {
        protected String op;

        private Specifier() {
        }
    }
}

