/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.query.api;

import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TasGraphDeserializer
extends TypeAdapter<List<Map<String, String>>> {
    private static final Logger logger = LoggerFactory.getLogger(TasGraphDeserializer.class);

    public void write(JsonWriter out, List<Map<String, String>> attributes) throws IOException {
    }

    public List<Map<String, String>> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return Collections.emptyList();
        }
        ArrayList<Map<String, String>> bags = new ArrayList<Map<String, String>>();
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals("vertices")) {
                in.beginArray();
                while (in.hasNext()) {
                    in.beginObject();
                    HashMap<String, String> bag = new HashMap<String, String>();
                    while (in.hasNext()) {
                        String field = in.nextName();
                        if (field.equals("attributes")) {
                            this.readAttributes(in, bag);
                            continue;
                        }
                        if (field.equals("id")) {
                            bag.put(field, in.nextString());
                            continue;
                        }
                        if (field.equals("externalId")) {
                            bag.put("externalId".toLowerCase(), in.nextString());
                            continue;
                        }
                        in.skipValue();
                    }
                    in.endObject();
                    if (bag.isEmpty()) continue;
                    bags.add(bag);
                }
                in.endArray();
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return bags;
    }

    private void readAttributes(JsonReader in, Map<String, String> bag) throws IOException {
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName().toLowerCase();
            JsonToken valueToken = in.peek();
            if (valueToken.equals((Object)JsonToken.STRING)) {
                bag.put(name, in.nextString());
                continue;
            }
            if (valueToken.equals((Object)JsonToken.BEGIN_ARRAY)) {
                in.beginArray();
                StringBuilder sb = new StringBuilder("[");
                int count = 0;
                while (in.hasNext()) {
                    JsonToken nextType = in.peek();
                    if (nextType.equals((Object)JsonToken.STRING)) {
                        if (count > 0) {
                            sb.append(",");
                        }
                        sb.append("\"");
                        sb.append(in.nextString());
                        sb.append("\"");
                        ++count;
                        continue;
                    }
                    in.skipValue();
                }
                sb.append("]");
                in.endArray();
                bag.put(name, sb.toString());
                continue;
            }
            in.skipValue();
        }
        in.endObject();
    }
}

