/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.query.api;

import com.ca.apm.gaps.TenantInfo;
import com.ca.apm.gaps.query.api.TasGraphDeserializer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpMethod;
import org.springframework.http.ResponseEntity;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestTemplate;

public class TasGraphQuery {
    private static final Logger logger = LoggerFactory.getLogger(TasGraphQuery.class);
    private static final String CONTAINER_QUERY_URL_UNFORMATTED = "%s/%s/tas/graph/query";
    private static final String ATTRIBUTE_SERIALIZE_UNFORMATTED = "%s:%s";
    private static final String ATTRIBUTE_CONCAT_TOKEN = " AND ";
    private String authToken;
    private String graphUrl;
    private final Gson gson;
    private static Type responseType = new TypeToken<List<Map<String, String>>>(){}.getType();
    private final RestTemplate restTemplate;
    private MultiValueMap<String, String> headers;
    private String body;

    TasGraphQuery(TenantInfo tenant, RestTemplate restTemplate, String layer, String attrbuteName, String attrbuteValue) {
        this(tenant, restTemplate, layer, Collections.singletonMap(attrbuteName, attrbuteValue));
    }

    TasGraphQuery(TenantInfo tenant, RestTemplate restTemplate, String layer, Map<String, String> attributesToMatch) {
        this.restTemplate = restTemplate;
        this.authToken = "Bearer " + tenant.getPublicApiToken();
        this.graphUrl = String.format(CONTAINER_QUERY_URL_UNFORMATTED, tenant.getAgentManagerUrl(), tenant.getTenantId());
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(responseType, (Object)new TasGraphDeserializer());
        this.gson = gsonBuilder.create();
        this.headers = new LinkedMultiValueMap();
        this.headers.add((Object)"Content-Type", (Object)"application/json");
        this.headers.add((Object)"Authorization", (Object)this.authToken);
        this.headers.add((Object)"Connection", (Object)"close");
        TasQuery query = new TasQuery();
        query.universe = new TasFilter("ATTRIBUTE").addExpression(new TasExpression("Source cluster", new String[]{"Enterprise Team Center"}));
        TasFilter attributeFilter = new TasFilter("ATTRIBUTE");
        for (Map.Entry<String, String> e : attributesToMatch.entrySet()) {
            attributeFilter.addExpression(new TasExpression(e.getKey(), new String[]{e.getValue()}));
        }
        query.filter = new TasTransformingFilter("TAKE_VERTICES", new TasAggregateFilter("AND").addInput(new TasFilter("LAYER", layer)).addInput(attributeFilter));
        this.body = this.gson.toJson((Object)query);
    }

    public Optional<List<Map<String, String>>> execute() {
        logger.debug("DXAPM TAS graph query to {}", (Object)this.graphUrl);
        logger.debug("DXAPM TAS graph query: {} ", (Object)this.body);
        HttpEntity entity = new HttpEntity((Object)this.body, this.headers);
        try {
            ResponseEntity response = this.restTemplate.exchange(this.graphUrl, HttpMethod.POST, entity, String.class, new Object[0]);
            logger.debug("DXAPM TAS graph query response : {}", response.getBody());
            List attributeBags = (List)this.gson.fromJson((String)response.getBody(), responseType);
            return attributeBags.isEmpty() ? Optional.empty() : Optional.of(attributeBags);
        }
        catch (Exception e) {
            logger.error("DXAPM TAS graph query failed: " + e.getMessage());
            logger.debug(e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
    }

    public static class TasQuery {
        TasFilter filter;
        TasFilter universe;
    }

    public static class TasFilter {
        public static final String OP_ATTRIBUTE = "ATTRIBUTE";
        public static final String OP_TAKE_VERTICES = "TAKE_VERTICES";
        public static final String OP_AND = "AND";
        public static final String OP_LAYER = "LAYER";
        String op;
        String value;
        List<TasExpression> expressions;

        public TasFilter(String op) {
            this.op = op;
        }

        public TasFilter(String op, String value) {
            this.op = op;
            this.value = value;
        }

        public TasFilter(String op, List<TasExpression> expressions) {
            this.op = op;
            this.expressions = expressions;
        }

        public TasFilter addExpression(TasExpression expression) {
            if (this.expressions == null) {
                this.expressions = new LinkedList<TasExpression>();
            }
            this.expressions.add(expression);
            return this;
        }
    }

    public static class TasTransformingFilter
    extends TasFilter {
        TasFilter input;

        public TasTransformingFilter(String op, TasFilter input) {
            super(op);
            this.input = input;
        }
    }

    public static class TasAggregateFilter
    extends TasFilter {
        List<TasFilter> input = new LinkedList<TasFilter>();

        public TasAggregateFilter(String op) {
            super(op);
        }

        public TasAggregateFilter addInput(TasFilter input) {
            this.input.add(input);
            return this;
        }
    }

    public static class TasExpression {
        String name;
        String[] values;

        public TasExpression(String name, String[] values) {
            this.name = name;
            this.values = values;
        }
    }
}

