/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.gaps.serializers;

import com.ca.apm.gaps.api.BasicLabel;
import com.ca.apm.gaps.api.BasicMonitor;
import com.ca.apm.gaps.api.BasicMonitoringTarget;
import com.ca.apm.gaps.api.Label;
import com.ca.apm.gaps.api.Monitor;
import com.ca.apm.gaps.api.MonitoringTarget;
import com.google.gson.TypeAdapter;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonToken;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TargetDeserializer
extends TypeAdapter<List<MonitoringTarget>> {
    private static final Logger logger = LoggerFactory.getLogger(TargetDeserializer.class);

    public void write(JsonWriter out, List<MonitoringTarget> value) throws IOException {
    }

    public List<MonitoringTarget> read(JsonReader in) throws IOException {
        if (in.peek() == JsonToken.NULL) {
            in.nextNull();
            return null;
        }
        ArrayList<MonitoringTarget> targets = new ArrayList<MonitoringTarget>();
        in.beginArray();
        while (in.hasNext()) {
            Optional<MonitoringTarget> target = this.readMonitoringTarget(in);
            if (!target.isPresent()) continue;
            targets.add(target.get());
        }
        in.endArray();
        return targets;
    }

    private Optional<MonitoringTarget> readMonitoringTarget(JsonReader in) throws IOException {
        BasicMonitoringTarget target = new BasicMonitoringTarget();
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals("name")) {
                target.setName(in.nextString());
                continue;
            }
            if (name.equals("id")) {
                target.setId(in.nextString());
                continue;
            }
            if (name.equals("parentId")) {
                target.setParentId(in.nextString());
                continue;
            }
            if (name.equals("type")) {
                target.setType(MonitoringTarget.MonitoringTargetType.valueOf((String)in.nextString().toUpperCase()));
                continue;
            }
            if (name.equals("labels")) {
                target.setLabels(this.readLabels(in));
                continue;
            }
            if (name.equals("monitors")) {
                in.beginArray();
                while (in.hasNext()) {
                    Optional<BasicMonitor> monitor = this.readMonitor(in);
                    if (!monitor.isPresent()) continue;
                    target.getMyMonitors().add((Monitor)monitor.get());
                }
                in.endArray();
                continue;
            }
            if (name.equals("childTargets")) {
                in.beginArray();
                while (in.hasNext()) {
                    Optional<MonitoringTarget> child = this.readMonitoringTarget(in);
                    if (!child.isPresent()) continue;
                    target.getChildTargets().add(child.get());
                }
                in.endArray();
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return target.getId() == null ? Optional.empty() : Optional.of(target);
    }

    private Optional<BasicMonitor> readMonitor(JsonReader in) throws IOException {
        BasicMonitor monitor = new BasicMonitor();
        in.beginObject();
        while (in.hasNext()) {
            String name = in.nextName();
            if (name.equals("name")) {
                monitor.setName(in.nextString());
                continue;
            }
            if (name.equals("id")) {
                monitor.setId(in.nextString());
                continue;
            }
            if (name.equals("bundleId")) {
                monitor.setBundleId(in.nextString());
                continue;
            }
            if (name.equals("parentId")) {
                monitor.setParentId(in.nextString());
                continue;
            }
            if (name.equals("labels")) {
                monitor.setLabels(this.readLabels(in));
                continue;
            }
            in.skipValue();
        }
        in.endObject();
        return monitor.getId() == null ? Optional.empty() : Optional.of(monitor);
    }

    private List<Label> readLabels(JsonReader in) throws IOException {
        ArrayList<Label> labels = new ArrayList<Label>();
        in.beginArray();
        while (in.hasNext()) {
            labels.add(this.readLabel(in));
        }
        in.endArray();
        return labels;
    }

    private Label readLabel(JsonReader in) throws IOException {
        String key = null;
        String value = null;
        in.beginObject();
        while (in.hasNext()) {
            key = in.nextName();
            value = in.nextString();
        }
        in.endObject();
        return new BasicLabel(key, value);
    }
}

