/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.agent.jvmprovider;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.gcmonitor.agent.jvmprovider.IbmJVMProvider;
import com.wily.introscope.gcmonitor.agent.jvmprovider.JVMProvider;
import com.wily.introscope.gcmonitor.agent.jvmprovider.SunJVMProvider;
import com.wily.introscope.gcmonitor.ui.Messages;

public class JVMProviderFactory {
    private static final int SUN_JVM = 1;
    private static final int IBM_JVM = 2;
    private static final int JROCKIT_JVM = 3;
    private static final int HP_JVM = 4;
    private static final int OPENJDK_JVM = 5;
    public static String SUN = "Java HotSpot";
    public static String JROCKIT = "BEA JRockit";
    public static String IBM = "IBM J9";
    public static String HP = "HP";
    public static String SAP = "SAP";
    public static String OPENJDK = "OpenJDK";
    public static String OPENJDK_ECLIPSE = "Eclipse OpenJ9";
    private int jvmType = 0;
    private static JVMProviderFactory providerFactory = new JVMProviderFactory();

    public static JVMProviderFactory getInstance() {
        return providerFactory;
    }

    public JVMProvider getJVMProvider(IAgent agent) {
        String jvm = System.getProperty("java.vm.name");
        return this.getJVMProvider(agent, jvm);
    }

    public JVMProvider getJVMProvider(IAgent agent, String jvm) {
        JVMProvider jvmProvider = null;
        this.getJvmType(jvm);
        switch (this.jvmType) {
            case 1: 
            case 5: {
                jvmProvider = new SunJVMProvider(agent, jvm);
                break;
            }
            case 2: {
                jvmProvider = new IbmJVMProvider(agent, jvm);
                break;
            }
            default: {
                Object[] args = new Object[]{jvm};
                agent.IAgent_getModuleFeedback().info(Messages.getString("GCMonitorExtn.NotSupported", args));
            }
        }
        return jvmProvider;
    }

    private void getJvmType(String jvm) {
        this.jvmType = 0;
        if (jvm != null) {
            if (jvm.startsWith(SUN) || jvm.contains(SAP)) {
                this.jvmType = 1;
            } else if (jvm.startsWith(JROCKIT)) {
                this.jvmType = 3;
            } else if (jvm.startsWith(IBM)) {
                this.jvmType = 2;
            } else if (jvm.startsWith(HP)) {
                this.jvmType = 4;
            } else if (jvm.startsWith(OPENJDK) || jvm.startsWith(OPENJDK_ECLIPSE)) {
                this.jvmType = 5;
            }
        }
    }
}

