/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.gcmonitor.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.gcmonitor.event.GCEvent;
import com.wily.introscope.gcmonitor.event.GCEventService;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.Module;
import javax.management.Notification;
import javax.management.NotificationListener;
import javax.management.openmbean.CompositeData;
import javax.management.openmbean.CompositeDataSupport;

public class GCNotificationListener
implements NotificationListener {
    private static Module module = new Module("GC Event");
    private static IAgent agent;
    private static final String GC_INFO = "gcInfo";
    private static final String STARTTIME = "startTime";
    private static final String ENDTIME = "endTime";
    private static final String DURATION = "duration";
    private static final String ACTION = "gcAction";
    private static final String CAUSE = "gcCause";
    private static final String NAME = "gcName";
    private static final String EVENT_PATH = "GC Monitor";
    private static final String JSON_INFO = "Json Info";

    @Override
    public void handleNotification(Notification notification, Object handback) {
        if (GCEventService.isEventMonitorEnabled()) {
            CompositeData cd = (CompositeData)notification.getUserData();
            CompositeDataSupport cds = (CompositeDataSupport)cd.get(GC_INFO);
            long startTime = -1L;
            long endTime = -1L;
            long duration = -1L;
            if (cds.containsKey(STARTTIME) && cds.containsKey(ENDTIME)) {
                startTime = (Long)cds.get(STARTTIME);
                endTime = (Long)cds.get(ENDTIME);
                if (cds.containsKey(DURATION)) {
                    duration = (Long)cds.get(DURATION);
                } else if (startTime >= 0L && endTime >= startTime) {
                    duration = endTime - startTime;
                }
            }
            if (GCEventService.shouldSendGCEvent(duration, startTime)) {
                long jvmStarttime = GCEventService.getJvmStartTime();
                GCEvent event = new GCEvent(jvmStarttime + startTime, jvmStarttime + endTime, duration);
                if (cd.containsKey(ACTION)) {
                    event.setAction(cd.get(ACTION).toString());
                }
                if (cd.containsKey(CAUSE)) {
                    event.setCause(cd.get(CAUSE).toString());
                }
                if (cd.containsKey(NAME)) {
                    event.setName(cd.get(NAME).toString());
                }
                Gson gson = new GsonBuilder().create();
                String jsonString = gson.toJson(event);
                TransactionComponentData tcdata = TransactionComponentData.createMilliSecTransactionComponentData((String)EVENT_PATH, (long)(jvmStarttime + startTime), (long)duration);
                tcdata.setParameterValue(JSON_INFO, jsonString);
                tcdata.setParameterValue("Trace Type", "GC");
                if (agent.IAgent_getModuleFeedback().isTraceEnabled() || agent.IAgent_getModuleFeedback().isTraceEnabled(module)) {
                    agent.IAgent_getModuleFeedback().trace(module, jsonString);
                }
                if (tcdata != null) {
                    agent.IAgent_queueEvent(tcdata);
                }
            }
        }
    }

    public GCNotificationListener(IAgent a) {
        agent = a;
    }
}

