/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.sqlagent.StatementNormalizer;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.WeakHashMap;

public final class SQLJRTStatementToSQLMappingTracer
extends ASingleInstanceTracerFactory {
    private static final Map sRTStatementToSQLMap;
    private static final Map sRTStatementTypeMap;
    private static final String kRTStatementClassName = "COM.ibm.db2os390.sqlj.runtime.DB2SQLJRTStatement";
    private static final String kConnectedProfileClassName = "COM.ibm.db2os390.sqlj.runtime.DB2SQLJConnectedProfile";
    private static final String kGetProfileDataMethodName = "getProfileData";
    private static final String kGetEntryInfoMethodName = "getEntryInfo";
    private static final String kGetSQLStringMethodName = "getSQLString";
    private final SQLAgentConfiguration fConfiguration;

    public SQLJRTStatementToSQLMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object rtStatement = data.getInvocationReturnValueAsObject();
        if (rtStatement == null) {
            return;
        }
        if (!rtStatement.getClass().getName().equalsIgnoreCase(kRTStatementClassName)) {
            Assertion.wilyAssert((String)"Expected a DB2SQLJRTStatement");
            return;
        }
        if (data.getInvocationParameterCount() == 0) {
            Assertion.wilyAssert((String)"No parameters are available");
            return;
        }
        int index = (Integer)data.getInvocationParameterAsObject(0);
        if (!data.getInvocationObject().getClass().getName().equalsIgnoreCase(kConnectedProfileClassName)) {
            Assertion.wilyAssert((String)"Expected a DB2SQLJConnectedProfile");
            return;
        }
        String rawSQL = null;
        try {
            Method getProfileDataMethod = data.getInvocationObject().getClass().getMethod(kGetProfileDataMethodName, new Class[0]);
            if (getProfileDataMethod == null) {
                AgentShim.handleError((String)"getProfileDataMethod is null for SQLJRTStatementToSQLMappingTracer.finishTracer", null);
                return;
            }
            Object profileData = getProfileDataMethod.invoke(data.getInvocationObject(), new Object[0]);
            Class[] getEntryInfoParamClasses = new Class[]{Integer.TYPE};
            Object[] getEntryInfoParam = new Object[]{index};
            Method getEntryInfoMethod = profileData.getClass().getMethod(kGetEntryInfoMethodName, getEntryInfoParamClasses);
            if (getEntryInfoMethod == null) {
                AgentShim.handleError((String)"getEntryInfoMethod is null for SQLJRTStatementToSQLMappingTracer.finishTracer", null);
                return;
            }
            Object entryInfo = getEntryInfoMethod.invoke(profileData, getEntryInfoParam);
            Method getSQLStringMethod = entryInfo.getClass().getMethod(kGetSQLStringMethodName, new Class[0]);
            if (getSQLStringMethod == null) {
                AgentShim.handleError((String)"getSQLStringMethod is null for SQLJRTStatementToSQLMappingTracer.finishTracer", null);
                return;
            }
            rawSQL = (String)getSQLStringMethod.invoke(entryInfo, new Object[0]);
        }
        catch (Throwable t) {
            AgentShim.handleError((String)"SQLJRTStatementToSQLMappingTracer.finishTracer unable to map RTStatement to SQL", (Throwable)t);
            return;
        }
        String normalizedSqlForMetricname = this.normalizeForMetricName(rawSQL);
        if (normalizedSqlForMetricname == null) {
            Assertion.wilyAssert((String)"Normalization didn't work");
            return;
        }
        String normalizedSqlForUserView = this.normalizeForUserView(rawSQL, normalizedSqlForMetricname);
        String sqlType = (String)sRTStatementTypeMap.get(this.getProbeIdentification().getProbeMethodName());
        if (sqlType == null) {
            Assertion.wilyAssert((String)"Couldn't figure out SQL statement type");
            return;
        }
        sRTStatementToSQLMap.put(rtStatement, new SQLAndTypeRecord(normalizedSqlForMetricname, normalizedSqlForUserView, sqlType));
    }

    private String normalizeForMetricName(String sql) {
        String answer = StatementNormalizer.normalizeSQL(sql, this.fConfiguration.getNormalizedMaxSQLLength());
        return answer;
    }

    private String normalizeForUserView(String sql, String normalizedForMetricName) {
        String answer = StatementNormalizer.normalizeSQLForUserView(sql, normalizedForMetricName, this.fConfiguration.getNormalizedMaxSQLLength());
        return answer;
    }

    public static String getSQL(Object statement) {
        return SQLJRTStatementToSQLMappingTracer.getSQL(statement, true);
    }

    public static String getSQL(Object statement, boolean forMetricName) {
        SQLAndTypeRecord record;
        if (statement != null && (record = (SQLAndTypeRecord)sRTStatementToSQLMap.get(statement)) != null) {
            if (forMetricName) {
                return record.fSQLForMetricName;
            }
            return record.fSQLForUserView;
        }
        return null;
    }

    public static String getSQLType(Object statement) {
        SQLAndTypeRecord record;
        if (statement != null && (record = (SQLAndTypeRecord)sRTStatementToSQLMap.get(statement)) != null) {
            return record.fType;
        }
        return null;
    }

    static {
        Map statementMap = null;
        HashMap<String, String> statementTypeMap = null;
        try {
            statementMap = Collections.synchronizedMap(new WeakHashMap());
            statementTypeMap = new HashMap<String, String>();
            statementTypeMap.put("getStatement", "Dynamic");
        }
        catch (Throwable t) {
            try {
                AgentShim.handleError((String)"Exception initializing SQLJRTStatementToSQLMappingTracer", (Throwable)t);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        sRTStatementToSQLMap = statementMap;
        sRTStatementTypeMap = statementTypeMap;
    }

    private static final class SQLAndTypeRecord {
        public String fSQLForMetricName;
        public String fSQLForUserView;
        public String fType;

        public SQLAndTypeRecord(String sqlForMetricName, String sqlForUserView, String type) {
            this.fSQLForMetricName = sqlForMetricName;
            this.fSQLForUserView = sqlForUserView;
            this.fType = type;
        }
    }
}

