/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.StatementToConnectionCache;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import com.wily.wilyassert.Assertion;
import java.sql.Connection;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Set;

public final class StatementToConnectionMappingTracer
extends ASingleInstanceTracerFactory {
    public static final String kStatementTypeKey = "statementtype";
    public static final int kStatementTypeDefault = 0;
    public static final int kStatementTypeOracleWrapped = 1;
    private final int statementType;
    private static final int kConnectionCountHarvestingPeriodInMillis = 15000;
    private static ConnectionCountingBehavior sConnectionCountingBehavior;

    private static synchronized void addBehaviorIfNecessary(IAgent agent) {
        if (sConnectionCountingBehavior == null) {
            sConnectionCountingBehavior = new ConnectionCountingBehavior(agent);
            agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)sConnectionCountingBehavior, "SQL Agent connection count metric", true, 15000L, true);
        }
    }

    public StatementToConnectionMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        StatementToConnectionMappingTracer.addBehaviorIfNecessary(agent);
        this.statementType = this.getIntegerParameter(kStatementTypeKey, 0);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object connection;
        Object object = connection = this.statementType == 0 ? data.getInvocationObject() : data.getInvocationParameterAsObject(0);
        if (connection == null) {
            return;
        }
        if (!(connection instanceof Connection)) {
            Assertion.wilyAssert((String)"Expected a Connection");
            return;
        }
        Object statement = data.getInvocationReturnValueAsObject();
        if (statement == null) {
            return;
        }
        if (!(statement instanceof Statement)) {
            Assertion.wilyAssert((String)"Expected a Statement");
            return;
        }
        StatementToConnectionCache.sStatementToConnectionCache.put(statement, connection);
        this.noticeConnection(data, connection);
    }

    public static Connection getConnection(Object statement) {
        Object shouldBeConnection;
        Connection result = null;
        if (statement != null && (shouldBeConnection = StatementToConnectionCache.sStatementToConnectionCache.get(statement)) instanceof Connection) {
            result = (Connection)shouldBeConnection;
        }
        return result;
    }

    public static void removeConnection(Connection connection) {
        if (sConnectionCountingBehavior != null) {
            sConnectionCountingBehavior.remove(connection);
        }
    }

    private void noticeConnection(InvocationData data, Object o) {
        if (o == null) {
            return;
        }
        if (!(o instanceof Connection)) {
            Assertion.wilyAssert((String)"expected a Connection");
            return;
        }
        Connection c = (Connection)o;
        String metricName = this.formatParameterizedName(data);
        if (metricName.indexOf("Unknown Database") == -1) {
            sConnectionCountingBehavior.noticeNewConnection(metricName, c);
        }
    }

    public static interface IOnCloseRemoveConnection {
        public void remove(Connection var1);
    }

    private static final class ConnectionCountingBehavior
    implements ITimestampedRunnable,
    IOnCloseRemoveConnection {
        private static final int kConnToMetricArraySize = 32;
        private static final int kConnToMetricBitmap = 31;
        private static final WeakIdentityHashMap[] sConnToMetric = new WeakIdentityHashMap[32];
        private final IAgent fAgent;

        public ConnectionCountingBehavior(IAgent agent) {
            this.fAgent = agent;
        }

        private WeakIdentityHashMap getConnToMetricMap(Object connection) {
            return sConnToMetric[this.getIndex(connection)];
        }

        private int getIndex(Object connection) {
            int index = System.identityHashCode(connection) & 0x1F;
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noticeNewConnection(String metricName, Connection connection) {
            WeakIdentityHashMap connections;
            WeakIdentityHashMap weakIdentityHashMap = connections = this.getConnToMetricMap(connection);
            synchronized (weakIdentityHashMap) {
                connections.put((Object)connection, (Object)metricName);
            }
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            this.updateConnectionCounts();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConnectionCounts() {
            HashMap<Object, int[]> metricNameToCount = new HashMap<Object, int[]>();
            for (int i = 0; i < 32; ++i) {
                Set entries = null;
                WeakIdentityHashMap weakIdentityHashMap = sConnToMetric[i];
                synchronized (weakIdentityHashMap) {
                    entries = sConnToMetric[i].entrySet();
                }
                for (WeakIdentityHashMap.Entry entry : entries) {
                    Object metricName = entry.getValue();
                    if (metricName == null) continue;
                    int[] count = (int[])metricNameToCount.get(metricName);
                    if (count == null) {
                        count = new int[1];
                        metricNameToCount.put(metricName, count);
                    }
                    count[0] = count[0] + 1;
                }
            }
            for (String metricName : metricNameToCount.keySet()) {
                ILongIntervalCounterDataAccumulator accum = this.fAgent.IAgent_getDataAccumulatorFactory().safeGetLongIntervalCounterDataAccumulator(metricName);
                int value = ((int[])metricNameToCount.get(metricName))[0];
                accum.ILongAggregatingDataAccumulator_recordDataPoint((long)value);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(Connection connection) {
            WeakIdentityHashMap connections;
            WeakIdentityHashMap weakIdentityHashMap = connections = this.getConnToMetricMap(connection);
            synchronized (weakIdentityHashMap) {
                connections.remove((Object)connection);
            }
        }

        static {
            for (int i = 0; i < 32; ++i) {
                ConnectionCountingBehavior.sConnToMetric[i] = new WeakIdentityHashMap();
            }
        }
    }
}

