/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.nt;

import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;

public final class TimeoutInterruptHandler {
    static Timer interruptTimer = new Timer("InterruptTimer", true);
    static ConcurrentHashMap<Thread, InterruptTask> outboundTimerTasksHash = new ConcurrentHashMap();
    static ConcurrentHashMap<Thread, InterruptTask> soTimerTasksHash = new ConcurrentHashMap();

    public static InterruptTask scheduleInterrupt(InterruptTaskType interruptTaskType, int n2, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        if (map.get(thread) != null) {
            throw new IllegalStateException("Interrupt task is already scheduled for the thread " + thread + " and the type " + (Object)((Object)interruptTaskType));
        }
        if (n2 <= 0) {
            return null;
        }
        InterruptTask interruptTask = new InterruptTask(thread, n2);
        interruptTimer.schedule((TimerTask)interruptTask, n2);
        map.put(Thread.currentThread(), interruptTask);
        return interruptTask;
    }

    public static InterruptTask cancelInterrupt(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = map.remove(thread);
        if (interruptTask != null) {
            interruptTask.cancel();
        }
        return interruptTask;
    }

    public static boolean isInterruptScheduled(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        return map.get(thread) != null;
    }

    public static void resetTimer(InterruptTaskType interruptTaskType, Thread thread) {
        Map<Thread, InterruptTask> map = TimeoutInterruptHandler.getMap(interruptTaskType);
        InterruptTask interruptTask = TimeoutInterruptHandler.cancelInterrupt(interruptTaskType, thread);
        if (interruptTask != null) {
            if (interruptTask.isInterrupted) {
                Thread.interrupted();
            }
            TimeoutInterruptHandler.scheduleInterrupt(interruptTaskType, interruptTask.time, thread);
        }
    }

    private static Map<Thread, InterruptTask> getMap(InterruptTaskType interruptTaskType) {
        if (interruptTaskType.equals((Object)InterruptTaskType.OUTBOUND_TIMEOUT)) {
            return outboundTimerTasksHash;
        }
        return soTimerTasksHash;
    }

    public static void stopTimer() {
        interruptTimer.cancel();
    }

    public static class InterruptTask
    extends TimerTask {
        Thread threadTobeInteruppted = null;
        boolean isInterrupted = false;
        int time;

        public InterruptTask(Thread thread, int n2) {
            this.threadTobeInteruppted = thread;
            this.time = n2;
        }

        public boolean isInterrupted() {
            return this.isInterrupted;
        }

        @Override
        public void run() {
            this.isInterrupted = true;
            this.threadTobeInteruppted.interrupt();
        }
    }

    public static enum InterruptTaskType {
        SO_TIMEOUT,
        OUTBOUND_TIMEOUT;

    }
}

