/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.apmservices.client.service.APMServicesClientAPIService;
import com.wily.introscope.agent.connection.IsengardServerConnectionManager;
import com.wily.introscope.agent.connection.PlatformServerConnectionManager;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.nass.NassMetricService;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.introscope.agent.stalemetric.ApmStaleMetricService;
import com.wily.introscope.agent.stalemetric.StaleMetricCleanScheduler;
import com.wily.introscope.agent.stalemetric.StaleMetricLogger;
import com.wily.introscope.agent.stalemetric.StaleMetricService;
import com.wily.util.ConfigurationWatcher;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.feedback.backend.NativeFeedbackBackendFactory;
import com.wily.util.feedback.backend.NativeFeedbackBackendRegistry;
import com.wily.util.properties.IndexedProperties;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;

public class CoreCommonService
implements IAgentService {
    public static final String kLogBackendDefault = "com.wily.introscope.agent.feedback.backend.logback.LogbackBackendFactory";
    private IAgent fAgent;
    private static final Module kModule = new Module("AgentCoreCommon");
    private IModuleFeedbackChannel fFeedback;
    private ConfigurationWatcher fConfigurationWatcher;
    private ExtensionAdministrator fAdministrator;
    private boolean fStaleMetricsRemovalEnabled = false;

    public int IAgentService_getServiceVersion() {
        return 2;
    }

    public void IAgentService_startService(final IAgent agent, Map params) {
        String oldProps;
        this.fAdministrator = (ExtensionAdministrator)params.get("ExtensionAdministrator");
        this.fAgent = agent;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        this.fFeedback.info(kModule, "Agent Core Common Utility Service starting");
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        String factoryClassName = props.getProperty("introscope.agent.log.backend", kLogBackendDefault);
        Class<?> clazz = null;
        NativeFeedbackBackendFactory factory = null;
        try {
            clazz = this.getClass().getClassLoader().loadClass(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            this.fFeedback.error("Could not load feedback backend factory:" + factoryClassName, (Throwable)e);
            return;
        }
        try {
            factory = (NativeFeedbackBackendFactory)clazz.getConstructor(IAgent.class).newInstance(agent);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            this.fFeedback.error("Could not instantiate logging backend from agent constructor:" + factoryClassName, (Throwable)e);
        }
        String configFileName = props.getProperty("introscope.agent.log.config.file");
        if (configFileName == null && (oldProps = props.getProperty("log4j.logger.IntroscopeAgent")) != null) {
            this.fFeedback.warn("Agent profile is using deprecated logging properties, please update logging properties in the profile to current release for logging configuration to work properly.");
        }
        if (factory == null) {
            try {
                factory = (NativeFeedbackBackendFactory)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
                this.fFeedback.debug("Could not instantiate logging backend from default constructor:" + factoryClassName, (Throwable)e);
            }
        }
        if (factory != null) {
            NativeFeedbackBackendRegistry.getInstance().registerNativeFeedbackBackendFactory(factory);
        } else {
            this.fFeedback.info("Could not instanciate logging feedback backend factory. Using default SystemOutBackend");
        }
        this.fStaleMetricsRemovalEnabled = agent.IAgent_getIndexedProperties().getBooleanProperty("introscope.agent.stalemetrics.removal.enabled", true);
        if (this.fStaleMetricsRemovalEnabled) {
            Runnable stalemetricRunnable = new Runnable(){

                @Override
                public void run() {
                    try {
                        StaleMetricLogger.initialize(agent);
                        StaleMetricService service = ApmStaleMetricService.getInstance();
                        service.registerStaleMetrics();
                        StaleMetricCleanScheduler.initSchedular(agent);
                        IsengardServerConnectionManager.setStaleMetricsService((StaleMetricService)service);
                    }
                    catch (Exception exp) {
                        CoreCommonService.this.fFeedback.warn("Failed to stale metric registration: " + exp.toString());
                    }
                }
            };
            agent.IAgent_getAgentThreadFactory().IThreadFactory_createNewThread("Agent StaleMetric Thread", stalemetricRunnable).start();
        }
        Runnable nassClientRunnable = new Runnable(){

            @Override
            public void run() {
                try {
                    APMServicesClientAPIService service = new APMServicesClientAPIService(agent, "");
                    PlatformServerConnectionManager.setNassMetricsService((NassMetricService)service);
                    if (CoreCommonService.this.fStaleMetricsRemovalEnabled) {
                        PlatformServerConnectionManager.setStaleMetricsService((StaleMetricService)ApmStaleMetricService.getInstance());
                    }
                }
                catch (Exception exp) {
                    CoreCommonService.this.fFeedback.warn("Failed Nass metric Service registration: " + exp);
                }
            }
        };
        agent.IAgent_getAgentThreadFactory().IThreadFactory_createNewThread("Nass Client Thread", nassClientRunnable).start();
    }

    public IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public Module getModule() {
        return kModule;
    }
}

