/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.apmservices.client.metadata.register;

import com.google.gson.Gson;
import com.google.gson.stream.JsonWriter;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.apmservices.client.httpclient.APMServicesHostConnection;
import com.wily.introscope.agent.apmservices.client.httpclient.HttpClientFactory;
import com.wily.introscope.agent.apmservices.client.metadata.register.MetricRegisterResponseHandler;
import com.wily.introscope.agent.apmservices.client.metadata.register.model.RegisteredMetric;
import com.wily.introscope.agent.apmservices.client.metadata.register.model.RegisteredMetrics;
import com.wily.introscope.agent.apmservices.client.nass.metricbatch.model.NASSMetric;
import com.wily.introscope.agent.apmservices.client.service.APMServicesClientAPIService;
import com.wily.introscope.agent.apmservices.client.sustainability.SustainabilityMetricReporter;
import com.wily.introscope.agent.apmservices.client.utils.APMServiceEndpointURL;
import com.wily.introscope.agent.apmservices.client.utils.APMServicesConnection;
import com.wily.introscope.agent.apmservices.client.utils.StringUtil;
import com.wily.introscope.agent.externalId.APMMetricExternalIdService;
import com.wily.introscope.agent.externalId.ExternalIdExtractor;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.introscope.spec.metric.AgentMetricData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;

public class MetricRegistrar {
    private IAgent agent;
    private APMMetricExternalIdService metricExternalIdService;
    private IModuleFeedbackChannel logger;
    private ConcurrentHashMap<NASSMetric, AgentMetric> metricIdCache;
    private static final long CACHE_SIZE = 1000000L;
    private static final long DEFAULT_AGE = 30L;
    protected final APMServicesConnection connection;
    String extensionName;

    public MetricRegistrar(APMServicesConnection connection, IAgent agent, String extensionName) {
        this.connection = connection;
        this.agent = agent;
        this.extensionName = extensionName;
        this.metricIdCache = new ConcurrentHashMap();
        this.logger = agent.IAgent_getModuleFeedback();
        this.metricExternalIdService = APMMetricExternalIdService.getInstance();
    }

    public void register(String hostAgentProcessName, Collection<AgentMetricData> batch, boolean firstTimeSlice, String bridgeAppName) {
        ArrayList<NASSMetric> metricsToRegister = new ArrayList<NASSMetric>();
        HashMap<String, String> metricAttributes = new HashMap<String, String>();
        if (bridgeAppName != null) {
            metricAttributes.put("appName", bridgeAppName);
        }
        for (AgentMetricData metricData : batch) {
            AgentMetric metric = metricData.getAgentMetric();
            if (metric == null || metric.getfNassMetricID() != null) continue;
            String attributePath = metric.getAgentMetricPrefix().toString();
            String attributeName = metric.getAttributeName();
            int metricType = metric.getAttributeType();
            long endTime = metricData.getDataValue().getStopTimestampInMillis();
            String value = metricData.getDataValue().getValueAsString();
            int interval = metricData.getFrequency().getPeriodInSeconds();
            attributePath = StringUtil.isEmpty(attributePath) ? attributeName : attributePath + ":" + attributeName;
            NASSMetric nassMetric = new NASSMetric(hostAgentProcessName, metricType, attributePath, metricAttributes);
            metricsToRegister.add(nassMetric);
            this.metricIdCache.put(nassMetric, metric);
        }
        int totalBatches = (int)Math.ceil((double)metricsToRegister.size() / (double)APMServicesClientAPIService.BATCH_TO_PROCESS.intValue());
        for (int batchToRegister = 0; batchToRegister < totalBatches; ++batchToRegister) {
            int start = batchToRegister * APMServicesClientAPIService.BATCH_TO_PROCESS;
            int end = Math.min(start + APMServicesClientAPIService.BATCH_TO_PROCESS, metricsToRegister.size());
            List<NASSMetric> currentBatch = metricsToRegister.subList(start, end);
            RegisteredMetrics registeredMetrics = this.registerMetadata(currentBatch, firstTimeSlice);
            this.updateAgentMetric(registeredMetrics.getMetrics());
        }
        this.metricIdCache.clear();
    }

    private void updateAgentMetric(Collection<RegisteredMetric> registeredMetrics) {
        for (RegisteredMetric registeredMetric : registeredMetrics) {
            AgentMetric metric = this.metricIdCache.get(registeredMetric.getMetric());
            if (metric != null) {
                metric.setfNassMetricID(registeredMetric.getId());
            } else {
                this.logger.error("Unable to update metricId for " + registeredMetric.getMetric().toString());
            }
            if (!this.logger.isTraceEnabled()) continue;
            this.logger.trace("Cache entry added:: " + registeredMetric.getMetric().toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RegisteredMetrics registerMetadata(Collection<NASSMetric> metricsToRegister, boolean firstTimeSlice) {
        RegisteredMetrics metricsRegistered = new RegisteredMetrics();
        if (metricsToRegister == null || metricsToRegister.isEmpty()) {
            return metricsRegistered;
        }
        String jsonPayload = this.createNASSRegistrationPayload(metricsToRegister);
        if (StringUtil.isEmpty(jsonPayload)) {
            return metricsRegistered;
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("NASS Metadata Payload to register :" + jsonPayload);
        }
        Request.Builder httpReq = HttpClientFactory.getRequestBuilder(this.connection.getCredential());
        APMServicesHostConnection hostConnection = this.connection.getApmServicesHostConnection();
        httpReq.url(hostConnection.getConnectionURL("/metadata/registerMetric"));
        if (firstTimeSlice) {
            this.logger.info("Nass Metric registration URL :" + hostConnection.getConnectionURL("/metadata/registerMetric"));
        }
        this.logger.info("Nass Metric registration count :" + metricsToRegister.size());
        this.logger.info("Nass Metric registration start time :" + System.currentTimeMillis());
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("authorization :" + String.format("Bearer %s", this.connection.getCredential()));
        }
        try (Response response = null;){
            if (jsonPayload != null) {
                httpReq.post(RequestBody.create((MediaType)APMServiceEndpointURL.JSON, (String)new String(jsonPayload.getBytes(), Charset.forName("UTF-8"))));
            }
            MetricRegisterResponseHandler metricRegisterResponseHandler = new MetricRegisterResponseHandler(this.logger);
            response = HttpClientFactory.executeRequestSync(httpReq.build());
            metricRegisterResponseHandler.onResponse(null, response);
            if (response.code() == 200) {
                String responseJSON = response.body().string();
                if (StringUtil.isNotBlank(responseJSON)) {
                    Gson gson = new Gson();
                    metricsRegistered = (RegisteredMetrics)gson.fromJson(responseJSON, RegisteredMetrics.class);
                    SustainabilityMetricReporter.reportIntCounter("Agent Stats|Sustainability|APM Services Client|NASS|Metadata:Number of Metric Register", metricsRegistered.getMetrics().size());
                } else {
                    this.logger.warn("Bulk registration of metrics failed empty response");
                    SustainabilityMetricReporter.reportIntCounter("Agent Stats|Sustainability|APM Services Client|NASS|Metadata:Number of Metric Register Failed", metricsToRegister.size());
                }
                this.logger.info("Nass Metric registration end time :" + System.currentTimeMillis());
            } else {
                this.logger.error("Cannot bulk register Metrics : HTTP Status code = " + response.code() + " Status Text: " + response.message() + " " + response.body().string());
                SustainabilityMetricReporter.reportIntCounter("Agent Stats|Sustainability|APM Services Client|NASS|Metadata:Number of Metric Register Failed", metricsToRegister.size());
            }
        }
        return metricsRegistered;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String createNASSRegistrationPayload(Collection<NASSMetric> metricsToRegister) {
        try (ByteArrayOutputStream jsonOut = new ByteArrayOutputStream();){
            String string;
            try (JsonWriter writer = new JsonWriter((Writer)new OutputStreamWriter((OutputStream)jsonOut, "UTF-8"));){
                writer.beginObject().name("metrics").beginArray();
                for (NASSMetric metric : metricsToRegister) {
                    String attributeName = metric.getAttributeName();
                    if (attributeName == null || attributeName.isEmpty()) continue;
                    if (attributeName.startsWith(":")) {
                        attributeName = attributeName.substring(1);
                    }
                    writer.beginObject();
                    writer.name("sourceName").value(metric.getSourceName());
                    writer.name("type").value((long)metric.getType());
                    writer.name("attributeName").value(attributeName);
                    ExternalIdExtractor externalIdExtractor = this.metricExternalIdService.getExtractor(attributeName);
                    if (externalIdExtractor != null) {
                        List<String> externalIds = externalIdExtractor.generateExternalId(attributeName, metric.getSourceName(), metric.getMetricAttributes());
                        writer.name("attributes").beginObject();
                        this.addMetricExternalIdsToAttributes(writer, externalIds);
                        externalIdExtractor.addMetricAttributes(writer);
                        writer.endObject();
                    }
                    writer.endObject();
                }
                writer.endArray().endObject();
                writer.flush();
                string = jsonOut.toString();
            }
            return string;
        }
        catch (Exception ex) {
            this.logger.error("Error generating JSON metric registration payload for NASS Metrics", (Throwable)ex);
            return null;
        }
    }

    private void addMetricExternalIdsToAttributes(JsonWriter writer, List<String> externalIds) throws IOException {
        if (externalIds != null && !externalIds.isEmpty()) {
            writer.name("external_ids").beginArray();
            for (String externalId : externalIds) {
                writer.value(externalId);
            }
            writer.endArray();
        }
    }
}

