/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.feedback.backend.logback;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.classic.util.ContextInitializer;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.joran.spi.JoranException;
import com.wily.introscope.agent.feedback.backend.logback.LogbackSeverityLevel;
import com.wily.util.feedback.SeverityLevel;
import com.wily.util.feedback.backend.IFeedbackBackend;
import com.wily.util.feedback.backend.PropertyConfigurableBackend;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.Properties;

public class LogbackBackend
extends PropertyConfigurableBackend {
    private static String configFileName = null;
    private final LoggerContext context = new LoggerContext();

    public static IFeedbackBackend getFeedbackBackend() {
        return LogbackBackend.getInstance();
    }

    public static LogbackBackend getInstance() {
        return Holder.sSingleton;
    }

    private LogbackBackend() {
        this.loadLoggerConfiguration();
    }

    public void loadLoggerConfiguration() {
        ContextInitializer contextInitializer = new ContextInitializer(this.context);
        try {
            URL configurationUrl;
            if (configFileName == null) {
                throw new IllegalStateException("Unable to find custom logback configuration file");
            }
            File file = new File(configFileName);
            URI uri = file.toURI();
            try {
                configurationUrl = uri.toURL();
            }
            catch (MalformedURLException e) {
                throw new IllegalStateException("Unable to find custom logback configuration file", e);
            }
            if (configurationUrl == null) {
                throw new IllegalStateException("Unable to find custom logback configuration file");
            }
            contextInitializer.configureByResource(configurationUrl);
        }
        catch (JoranException e) {
            throw new RuntimeException("Unable to configure logger", e);
        }
    }

    public static void setLogFileName(String name) {
        configFileName = name;
    }

    public void reloadLoggerConfiguration(Properties props) {
        this.context.reset();
        this.loadLoggerConfiguration();
        this.configureFromProperties(props);
    }

    public Object getLoggerByName(String name) {
        return this.context.getLogger(name);
    }

    private Logger getLoggerFromObjectCookie(Object cookie) {
        return (Logger)cookie;
    }

    public void log(Object logger, SeverityLevel level, Object message, Throwable t) {
        Logger l = this.getLoggerFromObjectCookie(logger);
        Level lvl = LogbackSeverityLevel.getLogbackSeverityLevel(level);
        l.log(null, Logger.FQCN, Level.toLocationAwareLoggerInteger(lvl), (String)message, null, t);
    }

    public SeverityLevel getEffectiveLevel(Object logger) {
        Level level = this.getLoggerFromObjectCookie(logger).getLevel();
        return LogbackSeverityLevel.getSeverityLevelFromLogback(level);
    }

    public SeverityLevel getLevel(Object logger) {
        Level level = this.getLoggerFromObjectCookie(logger).getLevel();
        return LogbackSeverityLevel.getSeverityLevelFromLogback(level);
    }

    public void setLevel(Object logger, SeverityLevel level) {
        Logger l = this.getLoggerFromObjectCookie(logger);
        l.setLevel(LogbackSeverityLevel.getLogbackSeverityLevel(level));
    }

    public void setAppender(Object logger, String appenderName) {
        Logger l = this.getLoggerFromObjectCookie(logger);
        l.setAdditive(false);
        Logger appenders = l.getLoggerContext().getLogger("APPENDERS");
        Appender<ILoggingEvent> appender = appenders.getAppender(appenderName);
        if (appender != null) {
            l.addAppender(appender);
        }
    }

    public boolean isEnabledFor(Object logger, SeverityLevel level) {
        return this.getLoggerFromObjectCookie(logger).isEnabledFor(LogbackSeverityLevel.getLogbackSeverityLevel(level));
    }

    public void setRootLevel(SeverityLevel level) {
        super.setRootLevel(level);
        Logger rootLogger = this.context.getLogger("ROOT");
        rootLogger.setLevel(LogbackSeverityLevel.getLogbackSeverityLevel(level));
    }

    public void setRootAppender(String appenderName) {
        Logger rootLogger = this.context.getLogger("ROOT");
        this.setAppender(rootLogger, appenderName);
    }

    public boolean isRootEnabledFor(SeverityLevel level) {
        Logger rootLogger = this.context.getLogger("ROOT");
        return rootLogger.isEnabledFor(LogbackSeverityLevel.getLogbackSeverityLevel(level));
    }

    public String getName(Object logger) {
        return this.getLoggerFromObjectCookie(logger).getName();
    }

    private static final class Holder {
        static final LogbackBackend sSingleton;
        static final String kSaxParserFactoryProperty = "javax.xml.parsers.SAXParserFactory";

        private Holder() {
        }

        static {
            try {
                String factory = System.getProperty(kSaxParserFactoryProperty);
                System.setProperty(kSaxParserFactoryProperty, "com.sun.org.apache.xerces.internal.jaxp.SAXParserFactoryImpl");
                sSingleton = new LogbackBackend();
                if (factory != null) {
                    System.setProperty(kSaxParserFactoryProperty, factory);
                } else {
                    System.clearProperty(kSaxParserFactoryProperty);
                }
            }
            catch (RuntimeException e) {
                throw new ExceptionInInitializerError(e);
            }
        }
    }
}

