/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.stalemetric;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.stalemetric.StaleMetricLogger;
import com.wily.introscope.agent.stalemetric.StaleMetricManager;
import com.wily.introscope.agent.stalemetric.model.CacheValue;
import com.wily.introscope.agent.stalemetric.model.StaleMetricDefinition;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.spec.metric.AgentMetricData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.regex.Pattern;

public class ApmStaleMetricManager
implements StaleMetricManager {
    private static final String EQUAL_OP_STR = "==";
    private static final String NOTEQUAL_OP_STR = "!=";
    private static final String GT_OP_STR = ">";
    private static final String LT_OP_STR = "<";
    private static final String GT_EQUAL_OP_STR = ">=";
    private static final String LT_EQUAL_OP_STR = "<=";
    private static final String METRIC_ATTRIBUTE_SEPERATOR = ":";
    private static final String METRIC_FOLDER_SEPERATOR = "|";
    private static final long MATCHED_METRIC_REMOVAL_TIME_SEC = 600L;
    private static final ApmStaleMetricManager INSTANCE = new ApmStaleMetricManager();
    private Set<StaleMetricDefinition> staleMetricSet = new HashSet<StaleMetricDefinition>();
    private Map<String, Long> matchedMetricPath = new ConcurrentHashMap<String, Long>();
    private Map<String, CacheValue> staleMetricValueMap = new ConcurrentHashMap<String, CacheValue>();

    private ApmStaleMetricManager() {
    }

    public static StaleMetricManager getInstance() {
        return INSTANCE;
    }

    @Override
    public void removeStaleMetrics(AgentMetricData[] agentMetricsData) {
        for (StaleMetricDefinition staleMetricDef : this.staleMetricSet) {
            try {
                for (AgentMetricData agentMetricData : agentMetricsData) {
                    String metricPath = agentMetricData.getAgentMetric().getAttributeURL();
                    if (staleMetricDef.getRootMetricNodeName() != null && (agentMetricData.getAgentMetricPrefix().isEmpty() || !agentMetricData.getAgentMetricPrefix().getSegment(0).equalsIgnoreCase(staleMetricDef.getRootMetricNodeName()))) continue;
                    if (this.isMetricMatches(metricPath, staleMetricDef.getStaleMetricRegexPattern())) {
                        if (StaleMetricLogger.getLogger().isDebugEnabled()) {
                            StaleMetricLogger.getLogger().debug("matched metricPath: " + metricPath);
                        }
                        CacheValue previousValue = this.staleMetricValueMap.get(metricPath);
                        String metricValue = agentMetricData.getDataValue().getValueAsString();
                        if (previousValue != null) {
                            StaleMetricDefinition result = this.compareStaleMetricValue(metricValue, staleMetricDef, previousValue);
                            previousValue.setValue(metricValue);
                            if (result != null && previousValue.isMarkDeleteTimeNotSet()) {
                                if (staleMetricDef.getRemoveNodeLevelMetrics()) {
                                    char delimiter = staleMetricDef.getRemoveNodeLevelMetricsDelimiter().charAt(0);
                                    String nodeLevelMetricPath = "";
                                    nodeLevelMetricPath = staleMetricDef.getRemoveNodeLevelMetricsDelimiter().equals(METRIC_ATTRIBUTE_SEPERATOR) ? metricPath.substring(0, metricPath.lastIndexOf(delimiter) + 1) : metricPath.substring(0, metricPath.lastIndexOf(delimiter));
                                    if (!this.matchedMetricPath.containsKey(nodeLevelMetricPath)) {
                                        this.matchedMetricPath.put(nodeLevelMetricPath, System.currentTimeMillis() / 1000L);
                                    }
                                } else {
                                    this.removeStaleMetric(metricPath, result);
                                }
                            }
                            if (staleMetricDef.getRemoveNodeLevelMetrics()) {
                                String operator = staleMetricDef.getOperator();
                                String compareValue = staleMetricDef.getCompareValue();
                                boolean value = this.compareMetricValue(operator, agentMetricData.getDataValue().getValueAsString(), compareValue);
                                if (!value) {
                                    char delimiter = staleMetricDef.getRemoveNodeLevelMetricsDelimiter().charAt(0);
                                    String nodeLevelMetricPath = "";
                                    nodeLevelMetricPath = staleMetricDef.getRemoveNodeLevelMetricsDelimiter().equals(METRIC_ATTRIBUTE_SEPERATOR) ? metricPath.substring(0, metricPath.lastIndexOf(delimiter) + 1) : metricPath.substring(0, metricPath.lastIndexOf(delimiter));
                                    if (this.matchedMetricPath.containsKey(nodeLevelMetricPath)) {
                                        this.matchedMetricPath.remove(nodeLevelMetricPath);
                                    }
                                }
                            }
                        } else {
                            this.staleMetricValueMap.put(metricPath, new CacheValue(staleMetricDef, metricPath, metricValue, staleMetricDef.getPollIntervalInSecs()));
                        }
                    }
                    if (!staleMetricDef.getRemoveNodeLevelMetrics()) continue;
                    Set<String> keyMetricPaths = this.matchedMetricPath.keySet();
                    for (String s : keyMetricPaths) {
                        if (!metricPath.contains(s)) continue;
                        this.removeMetric(metricPath);
                    }
                }
            }
            catch (Exception exp) {
                StaleMetricLogger.getLogger().warn("Error while removing stale metrics. Exception: " + exp);
            }
        }
    }

    @Override
    public void registerStaleMetric(StaleMetricDefinition staleMetric) {
        this.staleMetricSet.add(staleMetric);
    }

    @Override
    public void removeStaleMetric(String metricPathToStale, StaleMetricDefinition staleMetric) {
        List<String> metricsToRemove = staleMetric.getListOfStaleMetrics();
        String metricRootPath = metricPathToStale.split(METRIC_ATTRIBUTE_SEPERATOR)[0];
        String metricKey = "";
        for (String metricRemovePath : metricsToRemove) {
            if (metricRemovePath.contains(METRIC_ATTRIBUTE_SEPERATOR)) {
                if (staleMetric.isMetricPathAdjustmentRequired()) {
                    String adjustedMetricPath = ApmStaleMetricManager.getAdjustedMetricRootPath(metricRootPath, metricRemovePath);
                    metricKey = adjustedMetricPath + METRIC_FOLDER_SEPERATOR + metricRemovePath;
                } else {
                    metricKey = metricRootPath + METRIC_FOLDER_SEPERATOR + metricRemovePath;
                }
            } else {
                metricKey = metricRootPath + METRIC_ATTRIBUTE_SEPERATOR + metricRemovePath;
            }
            this.removeMetric(metricKey);
        }
        this.removeMetric(metricPathToStale);
    }

    private static String getAdjustedMetricRootPath(String metricRootPath, String metricRemovePath) {
        try {
            int metricsFolderCount = metricRemovePath.split(Pattern.quote(METRIC_FOLDER_SEPERATOR)).length;
            int fromSearchIndex = metricRootPath.length();
            for (int index = 0; index < metricsFolderCount; ++index) {
                fromSearchIndex = metricRootPath.lastIndexOf(METRIC_FOLDER_SEPERATOR, fromSearchIndex);
                metricRootPath = metricRootPath.substring(0, fromSearchIndex);
            }
        }
        catch (Exception exp) {
            StaleMetricLogger.getLogger().warn("Error in getAdjustedMetricRootPath method - " + exp.getMessage());
        }
        return metricRootPath;
    }

    private void removeMetric(String fullMetricName) {
        try {
            DataAccumulatorFactory dataAccumulatorFactory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
            dataAccumulatorFactory.removeMetric(fullMetricName);
            if (StaleMetricLogger.getLogger().isDebugEnabled()) {
                StaleMetricLogger.getLogger().debug("Stale Metric removed: " + fullMetricName);
            }
        }
        catch (Exception e) {
            StaleMetricLogger.getLogger().warn("Error while removing metric group: " + fullMetricName);
        }
    }

    private StaleMetricDefinition compareStaleMetricValue(String currentMetricValue, StaleMetricDefinition staleMetric, CacheValue previousValue) {
        StaleMetricDefinition result = null;
        String operator = staleMetric.getOperator();
        String compareValue = staleMetric.getCompareValue();
        boolean comparePrevValue = this.compareMetricValue(operator, previousValue.getValue(), compareValue);
        boolean compareCurrentValue = this.compareMetricValue(operator, currentMetricValue, compareValue);
        if (compareCurrentValue) {
            int count = previousValue.getMatchEventCount();
            if (count != -1 && (long)count < staleMetric.getExpiryAfterNumOfPoll()) {
                previousValue.setMatchEventCount(++count);
                if (staleMetric.getDeleteAfterNumOfPoll() > 0L) {
                    previousValue.setMarkDeleteTimeInSeconds();
                }
                result = staleMetric;
                if (StaleMetricLogger.getLogger().isDebugEnabled()) {
                    StaleMetricLogger.getLogger().debug("Stale event match : " + previousValue.getMetricPath() + " count: " + count);
                }
            } else if (comparePrevValue) {
                previousValue.setMatchEventCount(-1);
                if (StaleMetricLogger.getLogger().isDebugEnabled()) {
                    StaleMetricLogger.getLogger().debug("Stale event reset to -1: " + previousValue.getMetricPath());
                }
            }
        } else {
            previousValue.setMatchEventCount(0);
            if (staleMetric.getDeleteAfterNumOfPoll() > 0L) {
                previousValue.unsetMarkDeleteTimeInSeconds();
            }
            if (StaleMetricLogger.getLogger().isDebugEnabled()) {
                StaleMetricLogger.getLogger().debug("Stale event reset to 0 : " + previousValue.getMetricPath());
            }
        }
        return result;
    }

    private boolean compareMetricValue(String operator, String currentMetricValue, String compareValue) {
        boolean res = false;
        try {
            double curValue = Double.parseDouble(currentMetricValue);
            double compValue = Double.parseDouble(compareValue);
            if (operator.equals(EQUAL_OP_STR)) {
                res = curValue == compValue;
            } else if (operator.equals(NOTEQUAL_OP_STR)) {
                res = curValue != compValue;
            } else if (operator.equals(GT_OP_STR)) {
                res = curValue > compValue;
            } else if (operator.equals(LT_OP_STR)) {
                res = curValue < compValue;
            } else if (operator.equals(GT_EQUAL_OP_STR)) {
                res = curValue >= compValue;
            } else if (operator.equals(LT_EQUAL_OP_STR)) {
                res = curValue <= compValue;
            } else {
                StaleMetricLogger.getLogger().warn("No support for operator: " + operator);
            }
        }
        catch (Exception e) {
            StaleMetricLogger.getLogger().warn("error while parsing curMetricValue" + currentMetricValue + "Or compareValue" + compareValue);
        }
        return res;
    }

    private boolean isMetricMatches(String metricPath, Pattern staleMetricRegexPattern) {
        return staleMetricRegexPattern.matcher(metricPath).matches();
    }

    @Override
    public void cleanStaleMetricMapOnEntryExpire() {
        String metricPath = "";
        CacheValue cacheValue = null;
        long pollInterval = 0L;
        long curTimeInSecs = System.currentTimeMillis() / 1000L;
        long lastAccessTimeInSecs = 0L;
        ArrayList<String> metricToExpire = new ArrayList<String>();
        long expiryAfterNumOfPoll = 0L;
        long deleteAfterNumOfPoll = 0L;
        long markedDeletionTimeInSecs = 0L;
        try {
            for (Map.Entry<String, CacheValue> entry : this.staleMetricValueMap.entrySet()) {
                metricPath = entry.getKey();
                cacheValue = entry.getValue();
                pollInterval = cacheValue.getPollingIntervalInSecs();
                if (cacheValue.isMarkDeleteTimeNotSet()) {
                    lastAccessTimeInSecs = cacheValue.getLastAccessTimeInSeconds();
                    if (curTimeInSecs - lastAccessTimeInSecs < (expiryAfterNumOfPoll = cacheValue.getStaleMetric().getExpiryAfterNumOfPoll()) * pollInterval) continue;
                    if (StaleMetricLogger.getLogger().isDebugEnabled()) {
                        StaleMetricLogger.getLogger().debug("StaleMetricDefinition Expiring the metric" + metricPath + " after last accessTime in seconds :" + lastAccessTimeInSecs);
                    }
                    this.removeStaleMetric(metricPath, cacheValue.getStaleMetric());
                    metricToExpire.add(metricPath);
                    continue;
                }
                if (cacheValue.getMatchEventCount() == 0) {
                    if (!StaleMetricLogger.getLogger().isDebugEnabled()) continue;
                    StaleMetricLogger.getLogger().debug("Skipping StaleMetricDefinition for " + metricPath);
                    continue;
                }
                markedDeletionTimeInSecs = cacheValue.getMarkDeleteTimeInSeconds();
                if (curTimeInSecs - markedDeletionTimeInSecs < (deleteAfterNumOfPoll = cacheValue.getStaleMetric().getDeleteAfterNumOfPoll()) * pollInterval) continue;
                if (StaleMetricLogger.getLogger().isDebugEnabled()) {
                    StaleMetricLogger.getLogger().debug("StaleMetricDefinition deleting the metric" + metricPath + " after mark deletion Time in seconds :" + markedDeletionTimeInSecs);
                }
                this.removeStaleMetric(metricPath, cacheValue.getStaleMetric());
                metricToExpire.add(metricPath);
            }
        }
        catch (Exception exp) {
            StaleMetricLogger.getLogger().warn("Error while cleaning stale metric map. Exception: " + exp);
        }
        for (String key : metricToExpire) {
            this.staleMetricValueMap.remove(key);
        }
        Set<String> keyMetricPaths = this.matchedMetricPath.keySet();
        for (String s : keyMetricPaths) {
            long initTimeInSecs = this.matchedMetricPath.get(s);
            if (curTimeInSecs - initTimeInSecs <= 600L) continue;
            this.matchedMetricPath.remove(s);
        }
    }

    public Set<StaleMetricDefinition> getStaleMetricDefinitions() {
        return this.staleMetricSet;
    }
}

