/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.externalId;

import com.google.gson.stream.JsonWriter;
import com.wily.introscope.agent.externalId.model.MetricExternalIdDefinition;
import com.wily.util.StringUtils;
import com.wily.util.properties.IndexedProperties;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExternalIdExtractor {
    private static final String REGEX_PLACE_HOLDER = "\\{([^}]+)\\}";
    private static final String REGEX_GROUP_ALL = "(.*)";
    private static final String REGEX_GROUP_BEFORE_COLON = "(?:\\|[^:]+)?";
    private static final String REGEX_GROUP_METRIC_SUFFIX = "(?:\\|[^:]+)?:(.*)";
    private static final String REGEX_GROUP_BETWEEN_PIPE = "([^|]+)";
    private final MetricExternalIdDefinition externalIdDefinition;
    private final Pattern metricPathPatternRegex;
    private Matcher metricPathMatcher;
    private Map<String, Map<String, String>> metricVariableMap;
    private Map<String, String> variableMap;
    private String extensionType;
    private Map<String, String> metricAttributesMap;

    public ExternalIdExtractor(MetricExternalIdDefinition externalIdDefinition, IndexedProperties properties) {
        this.externalIdDefinition = externalIdDefinition;
        this.metricPathPatternRegex = this.getMetricPathRegexPattern();
        this.extensionType = externalIdDefinition.getMetricExtensionType();
        this.metricVariableMap = new HashMap<String, Map<String, String>>();
        this.variableMap = new HashMap<String, String>();
        this.addMetricAttributes(properties);
    }

    public void addMetricAttributes(JsonWriter writer) throws IOException {
        if (this.metricAttributesMap != null && !this.metricAttributesMap.isEmpty()) {
            for (Map.Entry<String, String> entry : this.metricAttributesMap.entrySet()) {
                String placeHolder;
                String value = entry.getValue();
                if (value != null && value.startsWith("{") && value.endsWith("}") && ExternalIdExtractor.isInteger(placeHolder = value.substring(1, value.length() - 1))) {
                    int groupIndex = Integer.parseInt(placeHolder);
                    value = groupIndex > 0 && groupIndex <= this.metricPathMatcher.groupCount() ? this.metricPathMatcher.group(groupIndex) : null;
                }
                writer.name(entry.getKey()).value(value);
            }
        }
    }

    public void addMetricAttributes(String rootPath, String attrKey, String attrValue) {
        Map<String, String> attributeMap;
        if (StringUtils.isEmpty((String)rootPath)) {
            rootPath = "|";
        }
        if ((attributeMap = this.metricVariableMap.get(rootPath)) == null) {
            attributeMap = new HashMap<String, String>();
            this.metricVariableMap.put(rootPath, attributeMap);
        }
        attributeMap.put(attrKey, attrValue);
    }

    public String getExtensionType() {
        return this.extensionType;
    }

    public boolean matchMetricPath(String metricAttribute) {
        this.metricPathMatcher = this.metricPathPatternRegex.matcher(metricAttribute);
        return this.metricPathMatcher.matches();
    }

    public List<String> generateExternalId(String metricAttribute, String sourceName, Map<String, String> attributes) {
        this.addVariablesToMap(metricAttribute, sourceName, attributes);
        ArrayList<String> externalIds = new ArrayList<String>();
        for (int i = 0; i < this.externalIdDefinition.getExternalIds().size(); ++i) {
            String externalId;
            String newExternalId = externalId = this.externalIdDefinition.getExternalIds().get(i);
            Iterator<String> iterator = this.extractPlaceholders(externalId).iterator();
            while (iterator.hasNext()) {
                String externalIdPlaceholder;
                String replacement = externalIdPlaceholder = iterator.next();
                if (ExternalIdExtractor.isInteger(externalIdPlaceholder)) {
                    replacement = this.metricPathMatcher.group(Integer.parseInt(externalIdPlaceholder));
                }
                if (this.variableMap.containsKey(externalIdPlaceholder)) {
                    replacement = this.variableMap.get(externalIdPlaceholder);
                }
                newExternalId = newExternalId.replace("{" + externalIdPlaceholder + "}", replacement);
            }
            externalIds.add(newExternalId);
        }
        return externalIds;
    }

    private void addMetricAttributes(IndexedProperties properties) {
        this.metricAttributesMap = new HashMap<String, String>();
        this.addStaticAttributes();
        this.addDynamicAttributes(properties);
    }

    private void addStaticAttributes() {
        Map<String, String> staticAttributes = this.externalIdDefinition.getStaticAttributes();
        if (staticAttributes != null && !staticAttributes.isEmpty()) {
            this.metricAttributesMap.putAll(staticAttributes);
        }
    }

    private void addDynamicAttributes(IndexedProperties properties) {
        Map<String, String> dynamicAttributes = this.externalIdDefinition.getDynamicAttributes();
        if (dynamicAttributes != null && !dynamicAttributes.isEmpty()) {
            for (Map.Entry<String, String> entry : dynamicAttributes.entrySet()) {
                String replacement = entry.getValue();
                String placeHolder = replacement.substring(1, replacement.length() - 1);
                String[] ValueAndType = placeHolder.split(":");
                switch (ValueAndType[0]) {
                    case "prop": {
                        replacement = properties.getProperty(ValueAndType[1]);
                        break;
                    }
                    case "env": {
                        replacement = System.getenv(ValueAndType[1]);
                    }
                }
                this.metricAttributesMap.put(entry.getKey(), replacement);
            }
        }
    }

    private Map<String, String> getVariableMap(String metricAttribute) {
        for (Map.Entry<String, Map<String, String>> entry : this.metricVariableMap.entrySet()) {
            String key = entry.getKey();
            if (!metricAttribute.startsWith(key + "|") && !metricAttribute.startsWith(key + ":")) continue;
            return entry.getValue();
        }
        return new HashMap<String, String>();
    }

    private Map<String, String> addVariablesToMap(String metricAttribute, String sourceName, Map<String, String> attributes) {
        String metricName = metricAttribute.substring(metricAttribute.lastIndexOf(":") + 1);
        this.variableMap = this.getVariableMap(metricAttribute);
        int groupCount = this.metricPathMatcher.groupCount();
        if (groupCount > 0) {
            String[] agentSource = sourceName.split("\\|");
            this.variableMap.put("metricName", metricName);
            this.variableMap.put("agentHost", agentSource[1]);
            this.variableMap.put("agentProcess", agentSource[3]);
            this.variableMap.put("agentName", agentSource[2]);
            this.variableMap.putAll(attributes);
        }
        return this.variableMap;
    }

    private static boolean isInteger(String input) {
        try {
            Integer.parseInt(input);
            return true;
        }
        catch (NumberFormatException var2) {
            return false;
        }
    }

    private Pattern getMetricPathRegexPattern() {
        String metricPathRegex = this.externalIdDefinition.getMetricPathRegex();
        metricPathRegex = metricPathRegex.replaceFirst("\\*", REGEX_GROUP_METRIC_SUFFIX).replaceAll("\\|", "\\\\|").replaceAll("\\{\\d+\\}", REGEX_GROUP_BETWEEN_PIPE).replaceAll("\\{metricPathSuffix\\}", REGEX_GROUP_BEFORE_COLON).replaceAll("\\{metricName\\}", REGEX_GROUP_ALL);
        return Pattern.compile(metricPathRegex);
    }

    private List<String> extractPlaceholders(String value) {
        Pattern pattern = Pattern.compile(REGEX_PLACE_HOLDER);
        Matcher matcher = pattern.matcher(value);
        ArrayList<String> valuePlaceholders = new ArrayList<String>();
        while (matcher.find()) {
            valuePlaceholders.add(matcher.group(1));
        }
        return valuePlaceholders;
    }
}

