/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.uma;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.collector.CollectorAgent;
import com.wily.introscope.agent.epa.EPAPluginRunner;
import com.wily.introscope.agent.runtime.java.enterprise.Java15AgentInitializationCallBackFactory;
import com.wily.introscope.agent.runtime.java.enterprise.Java2PostConstructionInitializationCallBack;
import com.wily.introscope.agent.runtime.java.enterprise.Java2PostConstructionInitializationHelper;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.agent.transformer.TransformerAdministrator;
import com.wily.introscope.agent.uma.UMAgentCommandLine;
import com.wily.introscope.agent.util.AgentCommandLine;
import com.wily.introscope.etc.AIntroscopeInstalledApplication;
import com.wily.introscope.install.IntroscopeInstallation;
import com.wily.introscope.install.IntroscopeVersion;
import com.wily.util.feedback.ApplicationFeedback;
import com.wily.util.feedback.AsynchFeedbackChannel;
import com.wily.util.feedback.CachingDelegatingFeedbackChannel;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.MultipleResourceBundleStringLocalizer;
import com.wily.util.version.IVersion;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Map;

public class UnifiedMonitoringAgent {
    private static UnifiedMonitoringAgent sSelf = null;
    static final Module kModule = new Module("InfrastructureAgent");
    private static final String kUnknown = "unknown";
    private IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;
    private final IVersion fVersion;
    private final UMAgentCommandLine fCommandLine;
    private final AIntroscopeInstalledApplication fApplication;
    private final EPAPluginRunner epagent;
    private final CollectorAgent collector;
    private IAgent fAgent;
    private static final long kMaxInitTime = 15000L;
    private volatile boolean isRunning = false;
    private static final String sFileSeparator = System.getProperty("file.separator");

    private static void setPropertiesFromEnvVariable() {
        String pattern = "(introscope_|agentManager_|log4j_|docker_|com_ca_apm_agent_).*";
        Map<String, String> envVars = System.getenv();
        for (Map.Entry<String, String> envVar : envVars.entrySet()) {
            String key = envVar.getKey();
            if (!key.matches(pattern)) continue;
            System.setProperty(key.replaceAll("_", "."), System.getenv(key));
        }
    }

    public UnifiedMonitoringAgent(String[] args) throws IOException {
        sSelf = this;
        UnifiedMonitoringAgent.setPropertiesFromEnvVariable();
        try {
            Java2PostConstructionInitializationHelper.initialize((Java2PostConstructionInitializationCallBack)Java15AgentInitializationCallBackFactory.createObject());
        }
        catch (Exception exception) {
            // empty catch block
        }
        ApplicationFeedback appFeedback = new ApplicationFeedback("InfrastructureAgent", false);
        this.fFeedback = appFeedback;
        this.fLocalizer = new MultipleResourceBundleStringLocalizer(this.fFeedback, UnifiedMonitoringAgent.class.getClassLoader(), new String[]{"com.wily.introscope.agent.uma.properties.AgentReleaseStrings", "com.wily.introscope.agent.uma.properties.AgentStrings", "com.wily.introscope.properties.IntroscopeCommonStrings", "com.wily.introscope.properties.IntroscopeErrorMessages", "com.wily.introscope.properties.IntroscopeVersionStrings", "com.wily.properties.CoreCommonStrings"});
        this.fVersion = new IntroscopeVersion(this.fLocalizer);
        this.fCommandLine = new UMAgentCommandLine(args, this.fLocalizer);
        this.epagent = new EPAPluginRunner();
        this.collector = new CollectorAgent((AgentCommandLine)this.fCommandLine);
        if (!this.fCommandLine.parseCommandLine()) {
            this.fApplication = null;
            return;
        }
        this.fApplication = new UMAgentIntrocopeInstalledApplication(appFeedback, this.fLocalizer, this.fVersion, this.fCommandLine.getInstallBase());
    }

    public boolean start() throws IOException, AgentNotAvailableException {
        String agentBuildAndReleaseVersion;
        if (this.fApplication == null) {
            return false;
        }
        if (this.fCommandLine.isHelpMode()) {
            this.fCommandLine.printHelp();
            return false;
        }
        TransformerAdministrator.setTransformerRequired((boolean)false);
        File prefsFile = this.getPrefsFile(this.fApplication.getInstallation());
        System.setProperty("com.wily.introscope.agentProfile", prefsFile.getCanonicalPath());
        UnifiedMonitoringAgent.GetFeedback().info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Agent_Config_File_Loading", prefsFile.getPath()));
        this.fAgent = AgentShim.getAgent((String)"InfrastructureAgent");
        this.fFeedback = this.fAgent.IAgent_getModuleFeedback();
        String cAgentProcessID = this.getAgentPid();
        if (!cAgentProcessID.equals(kUnknown)) {
            DataAccumulatorFactory factory = this.fAgent.IAgent_getDataAccumulatorFactory();
            factory.safeGetStringConstantDataAccumulator("ProcessID", cAgentProcessID);
        }
        if (!(agentBuildAndReleaseVersion = this.getAgentBuildAndReleaseVersion()).equals(kUnknown)) {
            DataAccumulatorFactory factory = this.fAgent.IAgent_getDataAccumulatorFactory();
            factory.safeGetStringConstantDataAccumulator("Build and Release", agentBuildAndReleaseVersion);
        }
        this.sendExtensionVersions();
        long startTime = System.currentTimeMillis();
        while (this.fAgent.IAgent_getIsengardServerConnection() == null) {
            long now;
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if ((now = System.currentTimeMillis()) <= startTime + 15000L) continue;
            this.fFeedback.error("Failed to initialize Isengard layer.");
            return false;
        }
        this.epagent.start(this.fAgent);
        this.collector.start(this.fAgent);
        this.isRunning = true;
        return true;
    }

    public boolean isRunning() {
        return this.isRunning;
    }

    public void stop() {
        this.isRunning = false;
    }

    private void sendExtensionVersions() {
        Map extensionVersions = this.fAgent.IAgent_getExtensionAdministrator().getExtensionVersions();
        for (Map.Entry entry : extensionVersions.entrySet()) {
            DataAccumulatorFactory factory = this.fAgent.IAgent_getDataAccumulatorFactory();
            factory.safeGetStringConstantDataAccumulator((String)entry.getKey(), (String)entry.getValue());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        try {
            UnifiedMonitoringAgent agent = new UnifiedMonitoringAgent(args);
            if (agent.start()) {
                UnifiedMonitoringAgent unifiedMonitoringAgent = agent;
                synchronized (unifiedMonitoringAgent) {
                    while (agent.isRunning) {
                        agent.wait();
                    }
                }
            }
            if (agent.fFeedback instanceof CachingDelegatingFeedbackChannel) {
                CachingDelegatingFeedbackChannel feedbackChannel = (CachingDelegatingFeedbackChannel)agent.fFeedback;
                feedbackChannel.removeAsyncLoggingFromHeartbeat();
                feedbackChannel.setShouldBuffer(false);
                feedbackChannel.flush();
            }
            Thread.sleep(3000L);
        }
        catch (Throwable t) {
            IModuleFeedbackChannel f = UnifiedMonitoringAgent.GetFeedback();
            IStringLocalizer l = UnifiedMonitoringAgent.GetLocalizer();
            if (null != f && null != l) {
                String s = l.IStringLocalizer_getFormattedLocalizedString("failed_to_start_1P", t.getMessage());
                f.error(s, t);
                if (f instanceof AsynchFeedbackChannel) {
                    ((AsynchFeedbackChannel)f).flush();
                }
                if (f instanceof CachingDelegatingFeedbackChannel) {
                    ((CachingDelegatingFeedbackChannel)f).flush();
                }
            }
            System.err.println("CollectorAgent failed to start because: " + t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    public static UnifiedMonitoringAgent GetInstance() {
        return sSelf;
    }

    static IModuleFeedbackChannel GetFeedback() {
        return UnifiedMonitoringAgent.GetInstance().getFeedback();
    }

    static IStringLocalizer GetLocalizer() {
        return UnifiedMonitoringAgent.GetInstance().getLocalizer();
    }

    IModuleFeedbackChannel getFeedback() {
        return this.fFeedback;
    }

    public IStringLocalizer getLocalizer() {
        return this.fLocalizer;
    }

    private String getAgentBuildAndReleaseVersion() {
        String agentBuildAndReleaseVersion = "Release " + this.fVersion.IVersion_getReleaseString() + " ( " + this.fVersion.IVersion_getBuildNumberString() + " ) ";
        return agentBuildAndReleaseVersion;
    }

    private String getAgentPid() {
        int atSymbol;
        String cAgentProcessID = System.getProperty("sun.java.launcher.pid");
        if (cAgentProcessID != null && (atSymbol = cAgentProcessID.indexOf("@")) > 0) {
            return cAgentProcessID.substring(0, atSymbol);
        }
        return kUnknown;
    }

    private File getPrefsFile(IntroscopeInstallation install) throws FileNotFoundException {
        File prefsFile;
        String prefsFileName = System.getProperty("com.wily.fieldeng.agent.profile");
        if (prefsFileName == null) {
            prefsFileName = System.getProperty("com.wily.introscope.agent.profile");
        }
        if (prefsFileName == null) {
            prefsFile = new File(install.getInstallationSubDirectoryPath(0) + sFileSeparator + "core" + sFileSeparator + "config", "IntroscopeAgent.profile");
            if (!prefsFile.exists()) {
                if (this.fFeedback.isVerboseEnabled()) {
                    this.fFeedback.verbose("CollecotrAgent cannot find " + prefsFile.getPath() + ", will now try CollectorAgent root directory");
                }
                prefsFile = new File("IntroscopeAgent.profile");
            }
        } else {
            String dir = new File(prefsFileName).getParent();
            prefsFile = dir == null ? new File(install.getInstallationSubDirectoryPath(6), prefsFileName) : new File(prefsFileName);
        }
        if (!prefsFile.exists()) {
            String message = UnifiedMonitoringAgent.GetLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Config_File_Err_File_Not_Found", prefsFile.getPath());
            throw new FileNotFoundException(message);
        }
        if (this.fFeedback.isVerboseEnabled()) {
            try {
                this.fFeedback.verbose(kModule, "Unified Monitoring Agent using preferences file " + prefsFile.getCanonicalPath());
            }
            catch (IOException e) {
                this.fFeedback.verbose(kModule, "Caught exception:", (Throwable)e);
            }
        }
        return prefsFile;
    }

    private static class UMAgentIntrocopeInstalledApplication
    extends AIntroscopeInstalledApplication {
        UMAgentIntrocopeInstalledApplication(ApplicationFeedback feedback, IStringLocalizer localizer, IVersion version, String installationBase) throws IOException {
            super(feedback, localizer, version, localizer.IStringLocalizer_getLocalizedString("Agent_Long_Name"), localizer.IStringLocalizer_getLocalizedString("Agent_Short_Name"), installationBase);
        }

        protected void doStart() throws Exception {
        }

        protected void doStop() throws Exception {
        }
    }
}

