/*
 * Decompiled with CFR 0.152.
 */
package com.wily.EDU.oswego.cs.dl.util.concurrent;

import com.wily.EDU.oswego.cs.dl.util.concurrent.ReadWriteLock;
import com.wily.EDU.oswego.cs.dl.util.concurrent.Sync;
import com.wily.EDU.oswego.cs.dl.util.concurrent.SynchronizedLong;
import java.util.Collection;
import java.util.Iterator;

public class SyncCollection
implements Collection {
    protected final Collection c_;
    protected final Sync rd_;
    protected final Sync wr_;
    protected final SynchronizedLong syncFailures_ = new SynchronizedLong(0L);

    public SyncCollection(Collection collection, Sync sync) {
        this(collection, sync, sync);
    }

    public SyncCollection(Collection collection, ReadWriteLock rwl) {
        this(collection, rwl.readLock(), rwl.writeLock());
    }

    public SyncCollection(Collection collection, Sync readLock, Sync writeLock) {
        this.c_ = collection;
        this.rd_ = readLock;
        this.wr_ = writeLock;
    }

    public Sync readerSync() {
        return this.rd_;
    }

    public Sync writerSync() {
        return this.wr_;
    }

    public long syncFailures() {
        return this.syncFailures_.get();
    }

    protected boolean beforeRead() {
        try {
            this.rd_.acquire();
            return false;
        }
        catch (InterruptedException ex) {
            this.syncFailures_.increment();
            return true;
        }
    }

    protected void afterRead(boolean wasInterrupted) {
        if (wasInterrupted) {
            Thread.currentThread().interrupt();
        } else {
            this.rd_.release();
        }
    }

    @Override
    public int size() {
        boolean wasInterrupted = this.beforeRead();
        try {
            int n = this.c_.size();
            return n;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    @Override
    public boolean isEmpty() {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.isEmpty();
            return bl;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.contains(o);
            return bl;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    @Override
    public Object[] toArray() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object[] objectArray = this.c_.toArray();
            return objectArray;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] toArray(Object[] a) {
        boolean wasInterrupted = this.beforeRead();
        try {
            Object[] objectArray = this.c_.toArray(a);
            return objectArray;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection coll) {
        boolean wasInterrupted = this.beforeRead();
        try {
            boolean bl = this.c_.containsAll(coll);
            return bl;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public boolean add(Object o) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.add(o);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public boolean remove(Object o) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.remove(o);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    public boolean addAll(Collection coll) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.addAll(coll);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    public boolean removeAll(Collection coll) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.removeAll(coll);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    public boolean retainAll(Collection coll) {
        this.wr_.acquire();
        try {
            boolean bl = this.c_.retainAll(coll);
            this.wr_.release();
            return bl;
        }
        catch (Throwable throwable) {
            try {
                this.wr_.release();
                throw throwable;
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }

    @Override
    public void clear() {
        try {
            this.wr_.acquire();
            try {
                this.c_.clear();
            }
            finally {
                this.wr_.release();
            }
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
            throw new UnsupportedOperationException();
        }
    }

    public Iterator unprotectedIterator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            Iterator iterator = this.c_.iterator();
            return iterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    @Override
    public Iterator iterator() {
        boolean wasInterrupted = this.beforeRead();
        try {
            SyncCollectionIterator syncCollectionIterator = new SyncCollectionIterator(this.c_.iterator());
            return syncCollectionIterator;
        }
        finally {
            this.afterRead(wasInterrupted);
        }
    }

    public class SyncCollectionIterator
    implements Iterator {
        protected final Iterator baseIterator_;

        SyncCollectionIterator(Iterator baseIterator) {
            this.baseIterator_ = baseIterator;
        }

        @Override
        public boolean hasNext() {
            boolean wasInterrupted = SyncCollection.this.beforeRead();
            try {
                boolean bl = this.baseIterator_.hasNext();
                return bl;
            }
            finally {
                SyncCollection.this.afterRead(wasInterrupted);
            }
        }

        public Object next() {
            boolean wasInterrupted = SyncCollection.this.beforeRead();
            try {
                Object e = this.baseIterator_.next();
                return e;
            }
            finally {
                SyncCollection.this.afterRead(wasInterrupted);
            }
        }

        @Override
        public void remove() {
            try {
                SyncCollection.this.wr_.acquire();
                try {
                    this.baseIterator_.remove();
                }
                finally {
                    SyncCollection.this.wr_.release();
                }
            }
            catch (InterruptedException ex) {
                Thread.currentThread().interrupt();
                throw new UnsupportedOperationException();
            }
        }
    }
}

