/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.directives.parser;

import com.wily.diagnos.cmp.directives.IDirective;
import com.wily.diagnos.cmp.directives.InvalidDirectiveException;
import com.wily.diagnos.cmp.directives.parser.DGParserException;
import com.wily.diagnos.cmp.directives.parser.ISingleDirectiveParser;
import com.wily.util.classfile.ClassFileException;
import com.wily.util.classfile.IClassSchemaPolicy;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;

public abstract class ADirectiveParser
implements ISingleDirectiveParser {
    private static final String kWrongNumberOfArgumentsMessage = "Directive has the wrong number of arguments";
    private static final String kIntegerValueExpected = "An integer value was expected";
    private static final String kNonNegativeIntegerValueExpected = "A non-negative integer value was expected";

    public abstract int getArgumentCount();

    protected boolean hasHelpMessage() {
        return true;
    }

    public abstract ILocalizableMessage getHelpMessage(String var1);

    public abstract IDirective parseDirective(IClassSchemaPolicy var1, String var2, String[] var3, String var4, int var5) throws ClassFileException, DGParserException, InvalidDirectiveException;

    @Override
    public final boolean ISingleDirectiveParser_hasHelpMessage() {
        return this.hasHelpMessage();
    }

    @Override
    public final ILocalizableMessage ISingleDirectiveParser_getHelpMessage(String keyword) {
        return this.getHelpMessage(keyword);
    }

    @Override
    public IDirective ISingleDirectiveParser_parseDirective(IClassSchemaPolicy schemaPolicy, String keyword, String[] arguments, String source, int lineNumber) throws ClassFileException, DGParserException, InvalidDirectiveException {
        this.doSimpleValidation(keyword, arguments);
        return this.parseDirective(schemaPolicy, keyword, arguments, source, lineNumber);
    }

    protected boolean hasFixedSyntax() {
        return true;
    }

    private void doSimpleValidation(String keyword, String[] arguments) throws DGParserException {
        int expectedArguments;
        int numArguments;
        if (this.hasFixedSyntax() && (numArguments = arguments.length) != (expectedArguments = this.getArgumentCount())) {
            String message = "Directive has the wrong number of arguments (found " + numArguments + ", expected " + expectedArguments + ")";
            String key = expectedArguments == 1 ? "Diagnos_Exception_Parsing_Wrong_Number_Of_Arguments_Singular" : "Diagnos_Exception_Parsing_Wrong_Number_Of_Arguments_Plural";
            throw new DGParserException(message, (ILocalizableMessage)new FormattedLocalizableMessage(key, String.valueOf(expectedArguments), String.valueOf(numArguments)));
        }
    }

    protected final int integerArgument(String arg) throws ClassFileException, DGParserException {
        try {
            return Integer.parseInt(arg);
        }
        catch (NumberFormatException nfe) {
            throw new DGParserException(kIntegerValueExpected + arg, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Parsing_Integer_Value_Expected_Key", arg, false));
        }
    }

    protected final int nonNegativeIntegerArgument(String arg) throws ClassFileException, DGParserException {
        int intValue = this.integerArgument(arg);
        if (intValue < 0) {
            throw new DGParserException(kNonNegativeIntegerValueExpected + arg, (ILocalizableMessage)new FormattedLocalizableMessage("Diagnos_Parsing_Non_Negative_Integer_Value_Expected_Key", arg, false));
        }
        return intValue;
    }
}

