/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.attributes.annotations;

import com.wily.diagnos.personality.java.classfile.attributes.annotations.DGElementValuePairs;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class DGAnnotation {
    private String fAnnotationType;
    private String fAnnotationClassName = "";
    private List fElementValuePairs;
    private DGConstantPool fConstantPool;

    public DGAnnotation(DataInputStream input, DGConstantPool constantPool) throws IOException {
        this.fConstantPool = constantPool;
        this.fElementValuePairs = new ArrayList();
        this.loadData(input);
    }

    private void loadData(DataInputStream input) throws IOException {
        short typeIndex = input.readShort();
        this.fAnnotationType = this.fConstantPool.getUtf(typeIndex);
        this.readClassName(this.fAnnotationType);
        short elementValuePairs = input.readShort();
        for (short i = 0; i < elementValuePairs; i = (short)(i + 1)) {
            DGElementValuePairs elementValuePair = new DGElementValuePairs(input, this.fConstantPool);
            this.fElementValuePairs.add(elementValuePair);
        }
    }

    private void readClassName(String classNameStr) {
        String className = classNameStr;
        if (classNameStr.startsWith("L")) {
            className = classNameStr.substring(1).replace('/', '.');
            this.fAnnotationClassName = className = className.substring(0, className.indexOf(59));
        }
    }

    public String getAnnotationClassName() {
        return this.fAnnotationClassName;
    }

    public String getAnnotationType() {
        return this.fAnnotationType;
    }

    public DGElementValuePairs[] getElementValuePairs() {
        return this.fElementValuePairs.toArray(new DGElementValuePairs[0]);
    }

    public int getElementValuePairsSize() {
        return this.fElementValuePairs.size();
    }
}

