/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGClassConstant
extends DGConstant {
    private int fCPI_className;

    DGClassConstant(DGConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool, 7);
        this.fCPI_className = in.readUnsignedShort();
    }

    public DGClassConstant(DGConstantPool constantPool, int index, int cpiClassName) {
        super(constantPool, 7);
        this.fIndex = index;
        this.fCPI_className = cpiClassName;
    }

    @Override
    public void validate() throws DGClassLoadingException {
        this.fPool.validateType(this.fCPI_className, 1);
    }

    public String getClassNameString() {
        return this.fPool.getUtf(this.fCPI_className);
    }

    public String toString() {
        return "# " + this.fIndex + ": Kind = Class (" + this.fTag + ")\n\tName = " + this.getClassNameString() + "(" + this.fCPI_className + ")";
    }

    @Override
    public void adjustIndices(int delta, int base) {
        if (this.fCPI_className > base) {
            this.fCPI_className += delta;
        }
        super.adjustIndices(delta, base);
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.fTag);
        out.writeShort(this.fCPI_className);
    }

    public boolean equals(DGConstant c) {
        if (c.getClass() != this.getClass()) {
            return false;
        }
        return ((DGClassConstant)c).getClassNameString().equals(this.getClassNameString());
    }
}

