/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.personality.java.classfile.constants;

import com.wily.diagnos.cmp.classfile.DGClassLoadingException;
import com.wily.diagnos.personality.java.classfile.constants.DGConstant;
import com.wily.diagnos.personality.java.classfile.constants.DGConstantPool;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class DGInvokeDynamicConstant
extends DGConstant {
    private int fBootStrapMethodAttrIndex;
    private int fCPI_nameAndType;

    protected DGInvokeDynamicConstant(DGConstantPool constantPool, int tag) {
        super(constantPool, tag);
    }

    public DGInvokeDynamicConstant(DGConstantPool constantPool, DataInputStream in) throws IOException {
        super(constantPool, 18);
        this.fBootStrapMethodAttrIndex = in.readUnsignedShort();
        this.fCPI_nameAndType = in.readUnsignedShort();
    }

    @Override
    public void validate() throws DGClassLoadingException {
        this.fPool.validateType(this.fCPI_nameAndType, 12);
    }

    public String toString() {
        return "# " + this.fIndex + ": Kind = CONSTANT_InvokeDynamic (" + this.fTag + ")\n\tBootStrapMethodIndex = " + this.fBootStrapMethodAttrIndex + "\tname_and_type_index = " + this.fCPI_nameAndType;
    }

    @Override
    public void write(DataOutputStream out) throws IOException {
        out.writeByte(this.fTag);
        out.writeShort(this.fBootStrapMethodAttrIndex);
        out.writeShort(this.fCPI_nameAndType);
    }
}

