/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient;

import com.wily.introscope.agent.trace.intelligent.Logger;
import java.util.concurrent.atomic.AtomicInteger;

public class ControlledErrorLogger {
    private final Logger.ILoggingHandler logger;
    private AtomicInteger messagesRemaining;

    public ControlledErrorLogger(Logger.ILoggingHandler logger, int maxMessages) {
        this.logger = logger;
        this.messagesRemaining = new AtomicInteger(maxMessages);
    }

    public void logError(String message, Throwable e) {
        if (this.messagesRemaining.get() > 0) {
            this.logger.logError(message);
            this.messagesRemaining.decrementAndGet();
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.logDebugMessage(e.getMessage(), e);
        }
    }
}

