/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxClamp;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongFluctuatingCounterDataAccumulator;

public class FluctuatingCounterMetric<T extends Number>
implements MetricValueListener<T> {
    final ILongFluctuatingCounterDataAccumulator acc;

    public FluctuatingCounterMetric(String metricName) {
        JmxClamp clamp = JmxClamp.getInstance(Configuration.getAgent());
        if (!clamp.isClampHit()) {
            JmxClamp.getInstance(Configuration.getAgent()).incrementMetricCounter();
            this.acc = Configuration.getAccumulatorFactory().safeGetLongFluctuatingCounterDataAccumulator(metricName);
        } else {
            clamp.printClampWarning();
            this.acc = null;
        }
    }

    @Override
    public void update(T value) {
        if (this.acc != null) {
            this.acc.ILongCounterDataAccumulator_setValue(((Number)value).longValue());
        }
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof Number;
    }

    @Override
    public void close() {
        if (this.acc != null) {
            JmxClamp.getInstance(Configuration.getAgent()).decrementMetricCounter();
            Configuration.getAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.acc);
        }
    }

    public int hashCode() {
        return this.acc == null ? 0 : this.acc.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        FluctuatingCounterMetric other = (FluctuatingCounterMetric)obj;
        return !(this.acc == null ? other.acc != null : !this.acc.equals(other.acc));
    }
}

