/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.metrics;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxClamp;
import com.ca.apm.agent.jmxclient.api.TaskExecutor;
import com.ca.apm.agent.jmxclient.metrics.MetricValueListener;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerAverageDataAccumulator;
import java.util.concurrent.TimeUnit;

public class IntegerPercentageMetric<T extends Number>
implements MetricValueListener<T> {
    final IIntegerAverageDataAccumulator acc;
    final TaskExecutor executor;
    final int runCount;

    public IntegerPercentageMetric(String metricName, TaskExecutor executor, long pollingIntervaInMs) {
        JmxClamp clamp = JmxClamp.getInstance(Configuration.getAgent());
        if (!clamp.isClampHit()) {
            JmxClamp.getInstance(Configuration.getAgent()).incrementMetricCounter();
            this.acc = Configuration.getAccumulatorFactory().safeGetIntegerPercentageDataAccumulator(metricName);
        } else {
            clamp.printClampWarning();
            this.acc = null;
        }
        this.executor = executor;
        this.runCount = (int)pollingIntervaInMs / 7500;
    }

    @Override
    public void update(T value) {
        if (this.acc != null) {
            final int intValue = ((Number)value).intValue();
            this.acc.IIntegerAggregatingDataAccumulator_recordDataPoint(intValue);
            int period = 7500;
            int count = this.runCount - 1;
            while (count-- > 0) {
                this.executor.schedule(new Runnable(){

                    @Override
                    public void run() {
                        IntegerPercentageMetric.this.acc.IIntegerAggregatingDataAccumulator_recordDataPoint(intValue);
                    }
                }, period, TimeUnit.MILLISECONDS);
                period += 7500;
            }
        }
    }

    @Override
    public boolean validate(Object value) {
        return value instanceof Number;
    }

    @Override
    public void close() {
        if (this.acc != null) {
            JmxClamp.getInstance(Configuration.getAgent()).decrementMetricCounter();
            Configuration.getAccumulatorFactory().removeDataAccumulator((IDataAccumulator)this.acc);
        }
    }

    public int hashCode() {
        return this.acc == null ? 0 : this.acc.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        IntegerPercentageMetric other = (IntegerPercentageMetric)obj;
        return !(this.acc == null ? other.acc != null : !this.acc.equals(other.acc));
    }
}

