/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.commands.traces;

import com.ca.agent.extensions.dbmon.DBMonCommand;
import com.ca.agent.extensions.dbmon.DBMonException;
import com.ca.agent.extensions.dbmon.DBMonMetricsContext;
import com.ca.agent.extensions.dbmon.entity.DBMonResultSet;
import com.ca.agent.extensions.dbmon.helper.DBMonCommonHelper;
import com.ca.agent.extensions.dbmon.schema.DBMonSQLTraceMapping;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.sql.Connection;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.Statement;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Map;

public class DBMonExecuteTraceQueryCommand
implements DBMonCommand {
    private IModuleFeedbackChannel logger;
    private Connection conn;
    private DBMonMetricsContext dbContext;
    public static final SimpleDateFormat DATE_FORMAT = new SimpleDateFormat("dd/MM/yyyy HH:mm:ss");
    public static final String TIMESTAMP_COLUMN_PARAM = ":timestampColumn:";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(DBMonMetricsContext dbContext) throws DBMonException {
        this.dbContext = dbContext;
        this.logger = dbContext.getAgent().IAgent_getModuleFeedback();
        this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Connecting to database...");
        try {
            this.conn = dbContext.initializeConnection();
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, dbContext.printDbConnectionDetails(), (Throwable)exe);
            return false;
        }
        try {
            for (DBMonSQLTraceMapping sqlTraceMapping : dbContext.getDbDetailsSchema().getSqlTraceMappings()) {
                if (sqlTraceMapping.getCustomIntervalSec() != null && sqlTraceMapping.getCustomIntervalSec() > 0) {
                    long executionInterval = (dbContext.getDbInfoSchema().getTraceInterval() > sqlTraceMapping.getCustomIntervalSec() ? dbContext.getDbInfoSchema().getTraceInterval() : sqlTraceMapping.getCustomIntervalSec()).intValue();
                    if (System.currentTimeMillis() - executionInterval * 1000L <= sqlTraceMapping.getLastExecutionTime()) continue;
                    this.fireAndUpdateMetric(sqlTraceMapping);
                    sqlTraceMapping.setLastExecutionTime(System.currentTimeMillis());
                    continue;
                }
                this.fireAndUpdateMetric(sqlTraceMapping);
            }
        }
        finally {
            try {
                if (this.conn != null) {
                    this.conn.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireAndUpdateMetric(DBMonSQLTraceMapping sqlTraceMapping) {
        String query = sqlTraceMapping.getQuery();
        String parameterizedQuery = this.preProcessQuery(sqlTraceMapping, query);
        long tsBeforeQryExec = System.currentTimeMillis();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query to be executed is:" + query);
        }
        Statement stmt = null;
        ResultSet rs = null;
        try {
            stmt = this.conn.createStatement();
            rs = stmt.executeQuery(parameterizedQuery);
            DBMonResultSet dbResultSet = new DBMonResultSet();
            DBMonCommonHelper.createResultSetObject(rs, dbResultSet);
            this.cacheExecutionTimestamp(sqlTraceMapping, query, dbResultSet);
            if (dbResultSet.getResultSet() != null) {
                this.dbContext.getDbTraceResultSet().put(query, dbResultSet);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug(DBMonMetricsContext.DBMON_MODULE, "Query" + query + "executed in (milli seconds) " + (System.currentTimeMillis() - tsBeforeQryExec));
                }
            } else {
                this.logger.warn(String.format("Query didn't returned any results for query [ %s ]", query));
            }
        }
        catch (Exception exe) {
            this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
        }
        finally {
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
            try {
                if (stmt != null) {
                    stmt.close();
                }
            }
            catch (Exception exe) {
                this.logger.error(DBMonMetricsContext.DBMON_MODULE, "", (Throwable)exe);
            }
        }
    }

    private void cacheExecutionTimestamp(DBMonSQLTraceMapping sqlTraceMapping, String query, DBMonResultSet dbResultSet) {
        if (sqlTraceMapping.getTimestampColumn() != null && !sqlTraceMapping.getTimestampColumn().isEmpty() && dbResultSet.getResultSet().size() > 0) {
            String timeStampString = dbResultSet.getResultSet().get(0).get(sqlTraceMapping.getTimestampColumn());
            this.dbContext.getTraceQueryExecutionCache().put(query, Timestamp.valueOf(timeStampString).getTime());
        }
    }

    private String preProcessQuery(DBMonSQLTraceMapping sqlTraceMapping, String query) {
        Map<String, String> queryVariables;
        String processedQuery = query;
        if (sqlTraceMapping.getTimestampColumn() != null) {
            long tsOffset = this.dbContext.getQueryExecutionCache().get(query) != null ? this.dbContext.getTraceQueryExecutionCache().get(query) : 0L;
            processedQuery = processedQuery.replace(TIMESTAMP_COLUMN_PARAM, DATE_FORMAT.format(new Date(tsOffset)));
        }
        if (this.dbContext.getDbInfoSchema().getDatabaseType().contains("SQL_SERVER_DB") && sqlTraceMapping.getTraceType() != null && sqlTraceMapping.getTraceType().equalsIgnoreCase("ExplainPlan")) {
            processedQuery = processedQuery.replace("execution_count_placeholder", this.dbContext.getDbInfoSchema().getExecutionCount());
        }
        if (this.dbContext.getDbInfoSchema().getDatabaseType().contains("SQL_SERVER_DB") && !sqlTraceMapping.getTraces().isEmpty() && sqlTraceMapping.getTraces().get(0).getTraceType().equalsIgnoreCase("TableScanQueries")) {
            processedQuery = processedQuery.replace("full_table_scan_min_row_count_placeholder", this.dbContext.getDbInfoSchema().getFullTableScanMinRowCount());
        }
        if ((queryVariables = sqlTraceMapping.getQueryVariables()) != null && queryVariables.size() > 0) {
            for (String variable : queryVariables.keySet()) {
                processedQuery = processedQuery.replace(variable, queryVariables.get(variable));
            }
        }
        return processedQuery;
    }
}

