/*
 * Decompiled with CFR 0.152.
 */
package com.ca.agent.extensions.dbmon.entity.query.plan;

import com.ca.agent.extensions.dbmon.entity.query.plan.DBMonQueryPlan;
import com.google.gson.annotations.SerializedName;
import java.sql.ResultSet;
import java.sql.SQLException;

public class OracleDBMonQueryPlan
extends DBMonQueryPlan {
    private String id;
    private String operation;
    private String objectName;
    private String objectType;
    private String optimizer;
    private transient int depth;
    private transient int position;
    private transient int cost;
    private transient int cpuPercent;
    private int bytes;
    private int rows;
    @SerializedName(value="Cost (% CPU)")
    private String costStr;
    private int parentId;
    private transient long io_cost;
    private transient long cpu_cost;
    private String time;

    public OracleDBMonQueryPlan(ResultSet rs) {
        super(rs);
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getOperation() {
        return this.operation;
    }

    public void setOperation(String operation) {
        this.operation = operation;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
    }

    public String getObjectType() {
        return this.objectType;
    }

    public void setObjectType(String objectType) {
        this.objectType = objectType;
    }

    public String getOptimizer() {
        return this.optimizer;
    }

    public void setOptimizer(String optimizer) {
        this.optimizer = optimizer;
    }

    public int getParentId() {
        return this.parentId;
    }

    public void setParentId(int parentId) {
        this.parentId = parentId;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public int getCost() {
        return this.cost;
    }

    public void setCost(int cost) {
        this.cost = cost;
    }

    public int getBytes() {
        return this.bytes;
    }

    public void setBytes(int bytes) {
        this.bytes = bytes;
    }

    public int getRows() {
        return this.rows;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    public String getTime() {
        return this.time;
    }

    public void setTime(String time) {
        this.time = time;
    }

    public int getCpuPercent() {
        return this.cpuPercent;
    }

    public void setCpuPercent(int cpuPercent) {
        this.cpuPercent = cpuPercent;
    }

    public String getCostStr() {
        return this.costStr;
    }

    public void setCostStr(String costStr) {
        this.costStr = costStr;
    }

    public long getIo_cost() {
        return this.io_cost;
    }

    public void setIo_cost(long io_cost) {
        this.io_cost = io_cost;
    }

    public long getCpu_cost() {
        return this.cpu_cost;
    }

    public void setCpu_cost(long cpu_cost) {
        this.cpu_cost = cpu_cost;
    }

    @Override
    public DBMonQueryPlan mapResultToPlan() throws SQLException {
        this.setId(this.rs.getString("ID"));
        this.setOperation(this.rs.getString("OPERATION"));
        this.setObjectName(this.rs.getString("OBJECT_NAME"));
        this.setObjectType(this.rs.getString("OBJECT_TYPE"));
        this.setOptimizer(this.rs.getString("OPTIMIZER"));
        this.setBytes(this.rs.getInt("BYTES"));
        this.setRows(this.rs.getInt("CARDINALITY"));
        this.setParentId(this.rs.getInt("PARENT_ID"));
        this.setDepth(this.rs.getInt("DEPTH"));
        this.setCost(this.rs.getInt("COST"));
        this.setPosition(this.rs.getInt("POSITION"));
        this.setTime(OracleDBMonQueryPlan.formatSecondsToTime(this.rs.getLong("TIME")));
        this.setCpu_cost(this.rs.getLong("CPU_COST"));
        this.setIo_cost(this.rs.getLong("IO_COST"));
        this.setCostStr(this.getCost() + " ( " + this.getCpuPercent() + " )");
        return this;
    }

    private static String formatSecondsToTime(long time) {
        return String.format("%02d:%02d:%02d", time / 3600L, time / 60L % 60L, time % 60L);
    }
}

