/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.http.helper;

import com.wily.introscope.agent.trace.InvocationData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.Arrays;
import java.util.List;

public class SpringHttpClientTracerHelper {
    private static Module module = new Module("SpringHttpClientTracerHelper");
    private static final String sharedDataKey = "com.wily.introscope.agent.trace.backend.http.helper.SpringHttpClientTracerHelper";
    private static final List expectedClassNames = Arrays.asList("org.springframework.http.client.SimpleBufferingClientHttpRequest");

    public static boolean startBackendTrace(InvocationData data, IModuleFeedbackChannel logger) {
        try {
            String className;
            Object sharedData = data.get(sharedDataKey);
            if (sharedData != null) {
                return (Boolean)sharedData;
            }
            if (data.getInvocationObject() != null && expectedClassNames.contains(className = data.getInvocationObject().getClass().getName())) {
                data.put(sharedDataKey, (Object)Boolean.FALSE);
                return false;
            }
        }
        catch (Exception e) {
            logger.error(module, "Unable to get inputStream:" + e);
            logger.error((Throwable)e);
        }
        data.put(sharedDataKey, (Object)Boolean.TRUE);
        return true;
    }

    public static boolean backendTraceStarted(InvocationData data) {
        Boolean traceWasStarted;
        Object sharedData = data.get(sharedDataKey);
        return sharedData != null && (traceWasStarted = (Boolean)sharedData) != false;
    }
}

