/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.utilities;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.util.feedback.Module;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLDecoder;

public class UrlUtilities {
    public static final String DEFAULT_CHAR_ENCODING = "UTF-8";
    private static final char URI_QUERY_CHAR = '?';
    private static final String URI_QUERY_STRING = String.valueOf('?');
    protected static final int ENCODE_FROM = 0;
    protected static final int ENCODE_TO = 1;
    protected static final String[][] PERCENT_ENCODE_URL_QUERY_CHARS = new String[][]{{"{", "%7B"}, {"}", "%7D"}, {"\"", "%22"}, {" ", "%20"}, {".", "%2E"}, {"|", "%7C"}};
    private static Module module = new Module("URL Utilities");

    public static String formatSpecialChars(String url) {
        if (url.indexOf(37) != -1 || url.indexOf(32) != -1) {
            StringBuilder bldr = UrlUtilities.replaceAllIllegalChars(new StringBuilder(url), BackendProtocolsConstants.ILLEGAL_URI_CHARS, '_');
            return bldr.toString();
        }
        return url;
    }

    public static String encodeSpecialChars(IAgent agent, String urlString) {
        if (urlString == null) {
            return null;
        }
        try {
            if (urlString.indexOf(124) != -1) {
                StringBuilder bldr = UrlUtilities.replaceAllIllegalChars(new StringBuilder(urlString), BackendProtocolsConstants.ILLEGAL_METRIC_CHARS, '_');
                urlString = bldr.toString();
            }
            return urlString;
        }
        catch (Exception ex) {
            agent.IAgent_getModuleFeedback().debug(module, "Unable to encode url" + urlString);
            agent.IAgent_getModuleFeedback().debug((Throwable)ex);
            return urlString;
        }
    }

    public static URI encodeValidURI(IAgent agent, URL url) throws URISyntaxException {
        String userInfo = UrlUtilities.encodeSpecialChars(agent, url.getUserInfo());
        String host = UrlUtilities.encodeSpecialChars(agent, url.getHost());
        String path = UrlUtilities.encodeSpecialChars(agent, url.getPath());
        String query = UrlUtilities.encodeSpecialChars(agent, url.getQuery());
        String ref = UrlUtilities.encodeSpecialChars(agent, url.getRef());
        return new URI(url.getProtocol(), userInfo, host, url.getPort(), path, query, ref);
    }

    public static URI encodeValidURI(IAgent agent, URI uri) throws MalformedURLException, URISyntaxException {
        URL url = uri.toURL();
        return UrlUtilities.encodeValidURI(agent, url);
    }

    public static String decodeSpecialChars(String url) {
        try {
            return URLDecoder.decode(url, DEFAULT_CHAR_ENCODING);
        }
        catch (Exception exception) {
            return url;
        }
    }

    public static String percentEncodeCertainQueryChars(String url) {
        if (url != null && url.length() > 0 && url.indexOf(63) != -1) {
            StringBuilder builder = new StringBuilder(url);
            int start = builder.indexOf(URI_QUERY_STRING) + URI_QUERY_STRING.length();
            for (String[] next : PERCENT_ENCODE_URL_QUERY_CHARS) {
                int index = builder.indexOf(next[0], start);
                if (index == -1) continue;
                do {
                    builder.replace(index, index + next[0].length(), next[1]);
                    index += next[1].length();
                } while ((index = builder.indexOf(next[0], index)) != -1);
            }
            return builder.toString();
        }
        return url;
    }

    public static StringBuilder replaceAllIllegalChars(StringBuilder builder, char[] illegalChars, char repChar) {
        if (builder != null && illegalChars != null) {
            String dest = String.valueOf(repChar);
            for (int i = 0; i < illegalChars.length; ++i) {
                String from = String.valueOf(illegalChars[i]);
                int index = builder.indexOf(from);
                while (index != -1) {
                    builder.replace(index, index + from.length(), dest);
                    index += dest.length();
                    index = builder.indexOf(from, index);
                }
            }
        }
        return builder;
    }

    public static String buildUrlString(URI uri, boolean withPort) {
        StringBuilder sb = new StringBuilder();
        if (uri.getScheme() != null) {
            sb.append(uri.getScheme()).append(':');
        }
        if (uri.getHost() != null) {
            sb.append("//");
            sb.append(uri.getHost());
            if (withPort && uri.getPort() != -1) {
                sb.append(":").append(uri.getPort());
            }
        }
        if (uri.getRawPath() != null) {
            sb.append(uri.getRawPath());
        }
        return sb.toString();
    }
}

