/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.epagent.AgentAccessor;
import com.wily.introscope.epagent.EPAConfig;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.util.ArrayList;
import java.util.Map;

public class StaleMetricsProcessor
implements Runnable {
    AgentAccessor agentAccessor = null;
    Map<String, Long> allMetrics = null;
    IModuleFeedbackChannel feedbackChannel = null;
    IStringLocalizer stringLocalizer = null;
    EPAConfig fconfig = null;
    Module fModule = null;

    public StaleMetricsProcessor(IModuleFeedbackChannel feedbackChannel, IStringLocalizer localizer, EPAConfig config) {
        this.feedbackChannel = feedbackChannel;
        this.stringLocalizer = localizer;
        this.fModule = new Module("StaleMetricsProcessor");
        this.fconfig = config;
    }

    @Override
    public void run() {
        this.agentAccessor = new AgentAccessor();
        this.allMetrics = this.agentAccessor.getAllMetrics();
        long staleMetricRemovalInterval = this.fconfig.getStaleMetricsRemovalInterval();
        long currentTime = System.currentTimeMillis();
        ArrayList<String> metricToExpire = new ArrayList<String>();
        try {
            if (this.allMetrics != null && staleMetricRemovalInterval > 0L) {
                for (Map.Entry<String, Long> entity : this.allMetrics.entrySet()) {
                    long lastAccessed = entity.getValue();
                    if (currentTime - lastAccessed < staleMetricRemovalInterval * 1000L) continue;
                    this.removeMetric(entity.getKey());
                    metricToExpire.add(entity.getKey());
                }
                if (metricToExpire != null) {
                    for (String key : metricToExpire) {
                        this.allMetrics.remove(key);
                    }
                }
            }
        }
        catch (Exception e) {
            this.feedbackChannel.debug("Exception occurred while occurring removing stale metric : ", (Throwable)e);
        }
    }

    private void removeMetric(String fullMetricPath) {
        try {
            this.feedbackChannel.debug("Removed stale metric : " + fullMetricPath);
            DataAccumulatorFactory dataAccumulatorFactory = AgentShim.getAgent().IAgent_getDataAccumulatorFactory();
            dataAccumulatorFactory.removeMetric(fullMetricPath);
        }
        catch (Exception e) {
            this.feedbackChannel.error("Exception occurred while removing metric from data accumulator : " + fullMetricPath, (Throwable)e);
        }
    }
}

