/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.api;

import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.IIntegerRateDataAccumulator;
import com.wily.introscope.epagent.api.ADataRecorderImpl;
import com.wily.introscope.epagent.api.IllegalValueException;
import com.wily.introscope.epagent.api.IntRateDataRecorder;

final class IntRateDataRecorderImpl
extends ADataRecorderImpl
implements IntRateDataRecorder {
    private static final String KNumberOfIncidentMustBePositiveMessage = "Number of incidents must be positive";

    IntRateDataRecorderImpl(IIntegerRateDataAccumulator backingAccumulator, MetricRecordingAdministrator metricRecordingAdministrator) {
        super((IDataAccumulator)backingAccumulator, metricRecordingAdministrator);
    }

    private IIntegerRateDataAccumulator getIntegerRateDataAccumulator() {
        return (IIntegerRateDataAccumulator)this.getBackingDataAccumulator();
    }

    @Override
    public void recordIncident() {
        if (!this.isShutoff()) {
            this.getIntegerRateDataAccumulator().IIntegerRateDataAccumulator_addSingleIncident();
        }
    }

    @Override
    public void recordMultipleIncidents(int incidentCount) throws IllegalValueException {
        if (incidentCount < 0) {
            throw new IllegalValueException(KNumberOfIncidentMustBePositiveMessage);
        }
        if (!this.isShutoff()) {
            this.getIntegerRateDataAccumulator().IIntegerRateDataAccumulator_addBatchIncidents(incidentCount);
        }
    }

    @Override
    public void recordValue(String stringValue) throws IllegalValueException {
        try {
            this.recordMultipleIncidents(Integer.parseInt(stringValue));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalValueException(nfe.getMessage());
        }
    }
}

