/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.api;

import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongIntervalCounterDataAccumulator;
import com.wily.introscope.epagent.api.ADataRecorderImpl;
import com.wily.introscope.epagent.api.IllegalValueException;
import com.wily.introscope.epagent.api.PerIntervalCounterDataRecorder;

final class PerIntervalCounterDataRecorderImpl
extends ADataRecorderImpl
implements PerIntervalCounterDataRecorder {
    private static final String KNumberOfIncidentMustBePositiveMessage = "Number of incidents must be positive";

    PerIntervalCounterDataRecorderImpl(ILongIntervalCounterDataAccumulator backingAccumulator, MetricRecordingAdministrator metricRecordingAdministrator) {
        super((IDataAccumulator)backingAccumulator, metricRecordingAdministrator);
    }

    private ILongIntervalCounterDataAccumulator getIntervalCounterDataAccumulator() {
        return (ILongIntervalCounterDataAccumulator)this.getBackingDataAccumulator();
    }

    @Override
    public void recordIncident() {
        if (!this.isShutoff()) {
            this.getIntervalCounterDataAccumulator().ILongIntervalCounterDataAccumulator_addSingleIncident();
        }
    }

    @Override
    public void recordMultipleIncidents(int incidentCount) throws IllegalValueException {
        if (incidentCount < 0) {
            throw new IllegalValueException(KNumberOfIncidentMustBePositiveMessage);
        }
        if (!this.isShutoff()) {
            this.getIntervalCounterDataAccumulator().ILongIntervalCounterDataAccumulator_addBatchIncidents((long)incidentCount);
        }
    }

    @Override
    public void recordValue(String stringValue) throws IllegalValueException {
        try {
            this.recordMultipleIncidents(Integer.parseInt(stringValue));
        }
        catch (NumberFormatException nfe) {
            throw new IllegalValueException(nfe.getMessage());
        }
    }
}

