/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.cron;

import com.wily.introscope.epagent.cron.CronEntry;
import com.wily.introscope.epagent.cron.CronEntryScheduleException;
import com.wily.introscope.epagent.cron.ICronJob;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.heartbeat.IntervalHeartbeat;
import com.wily.util.text.IStringLocalizer;
import java.util.Calendar;
import java.util.Date;
import java.util.Vector;

public class CronService {
    private Vector mCronJobEntries = new Vector();
    private Vector mJobsToRun = new Vector();
    private IModuleFeedbackChannel mFeedback;
    private IStringLocalizer mLocalizer;
    private static Module kModule = new Module("CronService");
    private static final int kFirstMinute = 0;
    private static final int kFirstHour = 0;
    private static final int kFirstDayOfMonth = 1;
    private static final int kFirstMonth = 1;
    private static final int kFirstDayOfWeek = 1;

    public CronService(IModuleFeedbackChannel feedback, IStringLocalizer localizer, IntervalHeartbeat heartbeat) {
        this.mFeedback = feedback;
        this.mLocalizer = localizer;
        ITimestampedRunnable tick = new ITimestampedRunnable(){

            public void ITimestampedRunnable_execute(long millis) {
                CronService.this.doTick(millis);
            }
        };
        heartbeat.addBehavior(tick, "Cron Service", true, 60000L, false);
    }

    private Module getModule() {
        return kModule;
    }

    public void validateSchedule(String schedule) throws CronEntryScheduleException {
        new CronEntry(this.mFeedback, this.mLocalizer, schedule, null);
    }

    public void addJob(ICronJob job, String schedule) throws CronEntryScheduleException {
        CronEntry entry = new CronEntry(this.mFeedback, this.mLocalizer, schedule, job);
        this.mCronJobEntries.add(entry);
    }

    private void runJob(ICronJob job) {
        try {
            job.ICronJob_run();
        }
        catch (Throwable t) {
            this.mFeedback.debug(this.getModule(), "Job \"" + job.ICronJob_getName() + "\" threw exception: ", t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runJobQueue() {
        Vector vector = this.mJobsToRun;
        synchronized (vector) {
            for (ICronJob job : this.mJobsToRun) {
                this.mFeedback.debug(this.getModule(), "Running job \"" + job.ICronJob_getName() + "\"");
                this.runJob(job);
            }
            this.mJobsToRun.clear();
        }
    }

    private void doTick(long nowInMillis) {
        Calendar now = Calendar.getInstance();
        now.setTime(new Date(nowInMillis));
        int minute = now.get(12) - 0;
        int hour = now.get(11) - 0;
        int dom = now.get(5) - 1;
        int month = now.get(2) + 1 - 1;
        int dow = now.get(7) - 1;
        for (CronEntry entry : this.mCronJobEntries) {
            if (!entry.getMinutes()[minute] || !entry.getHours()[hour] || !entry.getMonths()[month] || !(entry.runAllDaysOfWeek() || entry.runAllDaysOfMonth() ? entry.getDaysOfWeek()[dow] && entry.getDaysOfMonth()[dom] : entry.getDaysOfWeek()[dow] || entry.getDaysOfMonth()[dom])) continue;
            this.mJobsToRun.add(entry.getJob());
        }
        this.runJobQueue();
    }
}

