/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.epagent.EPAPlugin;
import com.wily.introscope.epagent.IPluginClassLookupHelper;
import com.wily.introscope.epagent.IPluginProcessor;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.api.DataRecorderFactory;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.StringEventDataRecorder;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

class ClassPlugin
extends EPAPlugin {
    private Method fMainEntryPoint = null;
    private boolean fUsesPrintStream = false;
    private final String fClassName;
    private final String[] fClassArgs;
    private final StringEventDataRecorder fClassRecorder;

    ClassPlugin(IPluginProcessor processor, String myKey, String myName, String classAndArgs) throws IllegalConfigurationException {
        super(processor, myKey, myName);
        String[] classAndArgArray = ClassPlugin.QuotedStringToStringArray(classAndArgs);
        String className = classAndArgArray[0];
        String[] classArgs = null;
        if (classAndArgArray.length > 1) {
            int argCount = classAndArgArray.length - 1;
            classArgs = new String[argCount];
            System.arraycopy(classAndArgArray, 1, classArgs, 0, argCount);
        }
        this.fClassName = className;
        this.fClassArgs = null != classArgs ? classArgs : new String[]{};
        try {
            this.fClassRecorder = DataRecorderFactory.createStringEventDataRecorder(this.fThisPluginMetricPath + ":Class");
            this.fClassRecorder.recordDataPoint(classAndArgs);
        }
        catch (IllegalMetricNameException e) {
            throw new IllegalConfigurationException(e);
        }
    }

    private void resolveClass() throws IllegalConfigurationException {
        Class<?> theClass = null;
        try {
            IPluginClassLookupHelper helper = this.fProcessor.getConfig().getClassHelper();
            if (helper != null) {
                theClass = helper.findClass(this.fClassName);
            }
            if (theClass == null) {
                theClass = Class.forName(this.fClassName);
            }
        }
        catch (ClassNotFoundException error) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("class_not_found_for_plugin_2P", this.fClassName, this.getName());
            throw new IllegalConfigurationException(s);
        }
        try {
            this.fMainEntryPoint = theClass.getMethod("main", String[].class, PrintStream.class);
            this.fUsesPrintStream = true;
        }
        catch (NoSuchMethodException error) {
            try {
                this.fMainEntryPoint = theClass.getMethod("main", String[].class);
            }
            catch (NoSuchMethodException nested) {
                String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("no_entry_point_1P", this.getName());
                throw new IllegalConfigurationException(s);
            }
        }
    }

    @Override
    protected void doRunPlugin() {
        try {
            if (this.fMainEntryPoint == null) {
                this.resolveClass();
            }
        }
        catch (IllegalConfigurationException e) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("class_plugin_error_1P", this.getName());
            this.fFeedback.error(this.fModule, s, (Throwable)((Object)e));
            return;
        }
        if (this.fUsesPrintStream) {
            this.runClassWithPrintStream();
        } else {
            this.runClass();
        }
    }

    private void runClass() {
        try {
            this.fMainEntryPoint.invoke(null, new Object[]{this.fClassArgs});
        }
        catch (InvocationTargetException t) {
            if (t.getTargetException() instanceof InterruptedException) {
                this.fFeedback.debug(this.fModule, "Plugin: " + this.getName() + " got: " + t + " due to timeout");
            } else {
                String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("class_plugin_error_1P", this.getName());
                this.fFeedback.error(this.fModule, s, (Throwable)t);
            }
        }
        catch (Throwable t) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("class_plugin_error_1P", this.getName());
            this.fFeedback.error(this.fModule, s, t);
        }
        finally {
            this.fFeedback.debug("Class plugin finished: " + this.fClassName);
        }
    }

    private void runClassWithPrintStream() {
        PipedOutputStream pos = new PipedOutputStream();
        PipedInputStream pis = new PipedInputStream();
        try {
            pos.connect(pis);
            pis.connect(pos);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Thread plugin = new Thread(new ClassRunner(this.fClassArgs, new PrintStream(pos)));
        plugin.start();
        BufferedReader inBuffer = new BufferedReader(new InputStreamReader(pis));
        try {
            String inString;
            while ((inString = inBuffer.readLine()) != null) {
                if ((inString = inString.trim()).length() == 0) continue;
                this.fFeedback.debug("Class plugin parsing line: " + inString + " from: " + this.fClassName);
                this.fProcessor.parseResults("Plugin " + this.getName(), inString);
            }
            inBuffer.close();
            pis.close();
        }
        catch (IOException e) {
            this.fFeedback.debug("Class plugin got IO error: " + e.getMessage());
        }
        plugin.interrupt();
        this.fFeedback.debug("Class plugin finished: " + this.fClassName);
    }

    private class ClassRunner
    implements Runnable {
        PrintStream fPS;
        Object[] fMethodArgs = new Object[2];

        ClassRunner(String[] args, PrintStream ps) {
            this.fPS = ps;
            this.fMethodArgs[0] = args;
            this.fMethodArgs[1] = ps;
        }

        @Override
        public void run() {
            try {
                ClassPlugin.this.fMainEntryPoint.invoke(null, this.fMethodArgs);
            }
            catch (InvocationTargetException t) {
                if (t.getTargetException() instanceof InterruptedException) {
                    ClassPlugin.this.fFeedback.debug(ClassPlugin.this.fModule, "Plugin: " + ClassPlugin.this.getName() + " got: " + t + " due to timeout");
                } else {
                    String s = ClassPlugin.this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("class_plugin_error_1P", ClassPlugin.this.getName());
                    ClassPlugin.this.fFeedback.error(ClassPlugin.this.fModule, s, (Throwable)t);
                }
            }
            catch (Throwable t) {
                String s = ClassPlugin.this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("class_plugin_error_1P", ClassPlugin.this.getName());
                ClassPlugin.this.fFeedback.error(ClassPlugin.this.fModule, s, t);
            }
            finally {
                this.fPS.close();
                ClassPlugin.this.fFeedback.debug("Class plugin finished: " + ClassPlugin.this.fClassName);
            }
        }
    }
}

