/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.epagent.EPAgent;
import com.wily.util.commandline.ACommandLineParser;
import com.wily.util.commandline.CommandLine;
import com.wily.util.commandline.ICommandLineParser;
import com.wily.util.commandline.ParsingException;
import com.wily.util.text.IStringLocalizer;
import java.io.PrintWriter;
import java.util.Vector;

class EPACommandLine
extends CommandLine {
    private static final String[] kHelpOptions = new String[]{"-help", "-h", "-?"};
    private static final String[] kVerboseOptions = new String[]{"-verbose", "-v"};
    private static final String[] kInstallBaseOptions = new String[]{"-installbase", "-i"};
    private String fInstallBase;

    public EPACommandLine(String[] commandLineStrings, IStringLocalizer localizer) {
        super(commandLineStrings);
        Vector<ACommandLineParser> parserVector = new Vector<ACommandLineParser>();
        parserVector.addElement(new HelpParser());
        parserVector.addElement(new VerboseParser());
        parserVector.addElement(new InstallBaseParser());
        Object[] parserArray = new ICommandLineParser[parserVector.size()];
        parserVector.copyInto(parserArray);
        this.setParsers((ICommandLineParser[])parserArray);
        try {
            this.parse();
        }
        catch (ParsingException e) {
            PrintWriter output = new PrintWriter(System.err, true);
            output.println(localizer.IStringLocalizer_getLocalizedString("EPA_Command_Line_Options_Header"));
            this.iterateParserHelp(output);
            output.flush();
        }
    }

    private void setVerboseMode(boolean mode) {
    }

    private void setHelpMode(boolean mode) {
    }

    private void setInstallBase(String base) {
        this.fInstallBase = base;
    }

    String getInstallBase() {
        return this.fInstallBase;
    }

    private class InstallBaseParser
    extends ACommandLineParser {
        public InstallBaseParser() {
            super(kInstallBaseOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) throws ParsingException {
            String installDir = EPACommandLine.this.consumeNextCommand(EPAgent.GetInstance().getLocalizer().IStringLocalizer_getFormattedLocalizedString("EPA_Command_Line_Missing_Argument", new String[]{currentCommand}));
            EPACommandLine.this.setInstallBase(installDir);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return "suppressed";
        }

        public boolean ISingleCommandHelpProvider_shouldSuppress() {
            return true;
        }
    }

    private class VerboseParser
    extends ACommandLineParser {
        public VerboseParser() {
            super(kVerboseOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            EPACommandLine.this.setVerboseMode(true);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return EPAgent.GetInstance().getLocalizer().IStringLocalizer_getLocalizedString("EPA_Command_Line_Help_Verbose_Command");
        }
    }

    private class HelpParser
    extends ACommandLineParser {
        public HelpParser() {
            super(kHelpOptions);
        }

        public void ICommandLineParser_parseCommand(CommandLine commandLine, String currentCommand) {
            EPACommandLine.this.setHelpMode(true);
        }

        public String ISingleCommandHelpProvider_getHelpText() {
            return EPAgent.GetInstance().getLocalizer().IStringLocalizer_getLocalizedString("EPA_Command_Line_Help_Help_Command");
        }
    }
}

