/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent;

import com.wily.introscope.epagent.IPluginProcessor;
import com.wily.introscope.epagent.IllegalConfigurationException;
import com.wily.introscope.epagent.api.DataRecorderFactory;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.IntAverageDataRecorder;
import com.wily.introscope.epagent.api.IntCounterDataRecorder;
import com.wily.introscope.epagent.api.PerIntervalCounterDataRecorder;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.text.IStringLocalizer;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class NetworkServer
implements Runnable {
    protected final Module fModule;
    protected final IModuleFeedbackChannel fFeedback;
    protected final IStringLocalizer fLocalizer;
    private ServerSocket fServerSocket;
    private boolean fRunning = false;
    private IntCounterDataRecorder fHitsTotal;
    private PerIntervalCounterDataRecorder fHitsPerInterval;
    private IntAverageDataRecorder fResponseTime;
    private IntCounterDataRecorder fConcurrentConnections;
    private final IPluginProcessor fProcessor;
    private final ExecutorService fThreadPool;

    public NetworkServer(IPluginProcessor processor, int port) throws IOException, IllegalConfigurationException {
        this.fProcessor = processor;
        this.fFeedback = this.fProcessor.getFeedback();
        this.fLocalizer = this.fProcessor.getLocalizer();
        this.fModule = new Module("NetworkServer");
        this.fThreadPool = Executors.newCachedThreadPool(new NetworkServerThreadFactory());
        try {
            this.fServerSocket = new ServerSocket(port);
            this.fHitsTotal = DataRecorderFactory.createIntCounterDataRecorder("EPAgent|Network Data:Hits Total");
            this.fHitsPerInterval = DataRecorderFactory.createPerIntervalCounterDataRecorder("EPAgent|Network Data:Hits Per Interval");
            this.fResponseTime = DataRecorderFactory.createIntAverageDataRecorder("EPAgent|Network Data:Average Response Time (ms)");
            this.fConcurrentConnections = DataRecorderFactory.createIntCounterDataRecorder("EPAgent|Network Data:Concurrency");
        }
        catch (IllegalMetricNameException e) {
            throw new IllegalConfigurationException(e);
        }
        catch (IOException e) {
            if (e.getMessage().toString().contains("Address already in use (Bind failed)")) {
                this.fFeedback.error(this.fModule, " EPAgent  networkDataPort is in use. please use different port. ", e.fillInStackTrace());
            }
            throw e;
        }
    }

    public void start() {
        new Thread(this).start();
    }

    public void stop() {
        this.fRunning = false;
        try {
            this.fServerSocket.close();
        }
        catch (IOException e) {
            String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("error_closing_socket_1P", "Network Server");
            this.fFeedback.error(this.fModule, s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        this.fRunning = true;
        while (this.fRunning) {
            try {
                Socket s = this.fServerSocket.accept();
                this.fFeedback.debug("Raw server got connection from : " + s.toString());
                this.fHitsTotal.add(1);
                this.fHitsPerInterval.recordIncident();
                IntCounterDataRecorder intCounterDataRecorder = this.fConcurrentConnections;
                synchronized (intCounterDataRecorder) {
                    this.fConcurrentConnections.add(1);
                }
                this.executeInPool(new RawServerConnection(s));
            }
            catch (Throwable t) {
                String s = this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("server_error_1P", "Network Server");
                this.fFeedback.error(this.fModule, s, t);
            }
        }
    }

    void executeInPool(Runnable r) {
        try {
            if (this.fThreadPool == null) {
                this.fFeedback.trace(this.fModule, "Cannot execute plugin as thread pool has not yet been created: " + r.toString());
            } else {
                this.fThreadPool.execute(r);
            }
        }
        catch (Exception e) {
            this.fFeedback.trace(this.fModule, "Error executing plugin: " + r.toString(), (Throwable)e);
        }
    }

    private class RawServerConnection
    implements Runnable {
        Socket fClient;

        RawServerConnection(Socket s) {
            this.fClient = s;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            StringBuffer fullString = null;
            String s = NetworkServer.this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("processing_connection_2P", "Network Server", this.fClient.toString());
            NetworkServer.this.fFeedback.info(s);
            long startTime = System.currentTimeMillis();
            boolean hasEndTag = true;
            String EVENT_START_TAG = "<event";
            String EVENT_END_TAG = "</event>";
            try {
                String inString;
                BufferedReader inBuffer = new BufferedReader(new InputStreamReader(this.fClient.getInputStream()));
                while ((inString = inBuffer.readLine()) != null) {
                    if ((inString = inString.trim()).length() == 0) continue;
                    if (inString.startsWith("<event") && !inString.endsWith("</event>")) {
                        hasEndTag = false;
                        fullString = new StringBuffer(inString);
                        continue;
                    }
                    if (!hasEndTag && !inString.endsWith("</event>") && fullString != null) {
                        fullString.append(inString);
                        continue;
                    }
                    if (!hasEndTag && inString.endsWith("</event>") && fullString != null) {
                        fullString.append(inString);
                        inString = fullString.toString();
                        fullString.setLength(0);
                        hasEndTag = true;
                    }
                    NetworkServer.this.fFeedback.debug("Raw server parsing line: " + inString + " from: " + this.fClient.toString());
                    NetworkServer.this.fProcessor.parseResults("Client at " + this.fClient.toString(), inString);
                }
                inBuffer.close();
                this.fClient.close();
                NetworkServer.this.fFeedback.debug("Raw server closed connection from: " + this.fClient.toString());
            }
            catch (IOException e) {
                NetworkServer.this.fFeedback.debug("Raw server got IO error from: " + this.fClient.toString());
            }
            finally {
                NetworkServer.this.fResponseTime.recordDataPoint((int)(System.currentTimeMillis() - startTime));
                IntCounterDataRecorder intCounterDataRecorder = NetworkServer.this.fConcurrentConnections;
                synchronized (intCounterDataRecorder) {
                    NetworkServer.this.fConcurrentConnections.subtract(1);
                }
            }
        }
    }

    static class NetworkServerThreadFactory
    implements ThreadFactory {
        final ThreadGroup group;
        final AtomicInteger threadNumber = new AtomicInteger(1);

        NetworkServerThreadFactory() {
            SecurityManager s = System.getSecurityManager();
            this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = new Thread(this.group, r, "EPAgent NetworkServer Worker " + this.threadNumber.getAndIncrement(), 0L);
            t.setDaemon(true);
            if (t.getPriority() != 5) {
                t.setPriority(5);
            }
            return t;
        }
    }
}

