/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.epagent.api;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.recording.MetricRecordingAdministrator;
import com.wily.introscope.agent.stat.DataAccumulatorFactory;
import com.wily.introscope.epagent.api.DataRecorder;
import com.wily.introscope.epagent.api.DummyDataRecorder;
import com.wily.introscope.epagent.api.IllegalMetricNameException;
import com.wily.introscope.epagent.api.IllegalMetricTypeException;
import com.wily.introscope.epagent.api.ImproperlyFormattedMetricNameException;
import com.wily.introscope.epagent.api.IntAverageDataRecorder;
import com.wily.introscope.epagent.api.IntAverageDataRecorderImpl;
import com.wily.introscope.epagent.api.IntCounterDataRecorder;
import com.wily.introscope.epagent.api.IntCounterDataRecorderImpl;
import com.wily.introscope.epagent.api.IntRateDataRecorder;
import com.wily.introscope.epagent.api.IntRateDataRecorderImpl;
import com.wily.introscope.epagent.api.LongAverageDataRecorder;
import com.wily.introscope.epagent.api.LongAverageDataRecorderImpl;
import com.wily.introscope.epagent.api.LongCounterDataRecorder;
import com.wily.introscope.epagent.api.LongCounterDataRecorderImpl;
import com.wily.introscope.epagent.api.MetricNameAlreadyInUseException;
import com.wily.introscope.epagent.api.PerIntervalCounterDataRecorder;
import com.wily.introscope.epagent.api.PerIntervalCounterDataRecorderImpl;
import com.wily.introscope.epagent.api.StringEventDataRecorder;
import com.wily.introscope.epagent.api.StringEventDataRecorderImpl;
import com.wily.introscope.epagent.api.TimestampDataRecorder;
import com.wily.introscope.epagent.api.TimestampDataRecorderImpl;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Hashtable;

public final class DataRecorderFactory {
    private static final Hashtable fMetricNameToDataRecorderMap = new Hashtable();
    private static final IDataRecorderCreator sLongAverageDataRecorderCreator = new LongAverageDataRecorderCreator();
    private static final IDataRecorderCreator sIntAverageDataRecorderCreator = new IntAverageDataRecorderCreator();
    private static final IDataRecorderCreator sLongCounterDataRecorderCreator = new LongCounterDataRecorderCreator();
    private static final IDataRecorderCreator sIntCounterDataRecorderCreator = new IntCounterDataRecorderCreator();
    private static final IDataRecorderCreator sIntRateDataRecorderCreator = new IntRateDataRecorderCreator();
    private static final IDataRecorderCreator sStringEventDataRecorderCreator = new StringEventDataRecorderCreator();
    private static final IDataRecorderCreator sTimestampDataRecorderCreator = new TimestampDataRecorderCreator();
    private static final IDataRecorderCreator sPerIntervalCounterDataRecorderCreator = new PerIntervalCounterDataRecorderCreator();
    private static final String kNullMetricNameNotAllowedMessage = "null metric names are not allowed";
    private static final String kMetricNameAlreadyInUseMessage = "\"{0}\" is already in use by another DataRecorder of a different type";
    public static final String kLongAverageDataRecorderType = "LongAverage";
    public static final String kIntAverageDataRecorderType = "IntAverage";
    public static final String kLongCounterDataRecorderType = "LongCounter";
    public static final String kIntCounterDataRecorderType = "IntCounter";
    public static final String kIntRateDataRecorderType = "IntRate";
    public static final String kStringEventDataRecorderType = "StringEvent";
    public static final String kTimestampDataRecorderType = "TimeStamp";
    public static final String kPerIntervalDataRecorderType = "PerIntervalCounter";
    private static final HashMap sCreatorHash = new HashMap();

    private DataRecorderFactory() {
    }

    public static synchronized LongAverageDataRecorder createLongAverageDataRecorder(String metricName) throws IllegalMetricNameException {
        return (LongAverageDataRecorder)DataRecorderFactory.createDataRecorder(sLongAverageDataRecorderCreator, metricName);
    }

    public static synchronized IntAverageDataRecorder createIntAverageDataRecorder(String metricName) throws IllegalMetricNameException {
        return (IntAverageDataRecorder)DataRecorderFactory.createDataRecorder(sIntAverageDataRecorderCreator, metricName);
    }

    public static synchronized LongCounterDataRecorder createLongCounterDataRecorder(String metricName) throws IllegalMetricNameException {
        return (LongCounterDataRecorder)DataRecorderFactory.createDataRecorder(sLongCounterDataRecorderCreator, metricName);
    }

    public static synchronized IntCounterDataRecorder createIntCounterDataRecorder(String metricName) throws IllegalMetricNameException {
        return (IntCounterDataRecorder)DataRecorderFactory.createDataRecorder(sIntCounterDataRecorderCreator, metricName);
    }

    public static synchronized IntRateDataRecorder createIntRateDataRecorder(String metricName) throws IllegalMetricNameException {
        return (IntRateDataRecorder)DataRecorderFactory.createDataRecorder(sIntRateDataRecorderCreator, metricName);
    }

    public static synchronized StringEventDataRecorder createStringEventDataRecorder(String metricName) throws IllegalMetricNameException {
        return (StringEventDataRecorder)DataRecorderFactory.createDataRecorder(sStringEventDataRecorderCreator, metricName);
    }

    public static synchronized TimestampDataRecorder createTimestampDataRecorder(String metricName) throws IllegalMetricNameException {
        return (TimestampDataRecorder)DataRecorderFactory.createDataRecorder(sTimestampDataRecorderCreator, metricName);
    }

    public static synchronized PerIntervalCounterDataRecorder createPerIntervalCounterDataRecorder(String metricName) throws IllegalMetricNameException {
        return (PerIntervalCounterDataRecorder)DataRecorderFactory.createDataRecorder(sPerIntervalCounterDataRecorderCreator, metricName);
    }

    private static IAgent getAgent() throws AgentNotAvailableException {
        return AgentShim.getAgent();
    }

    private static MetricRecordingAdministrator getMetricRecordingAdministrator() throws AgentNotAvailableException {
        return DataRecorderFactory.getAgent().IAgent_getMetricRecordingAdministrator();
    }

    private static DataAccumulatorFactory getDataAccumulatorFactory() throws AgentNotAvailableException {
        return DataRecorderFactory.getAgent().IAgent_getDataAccumulatorFactory();
    }

    private static synchronized DataRecorder createDataRecorder(IDataRecorderCreator creator, String metricName) throws IllegalMetricNameException {
        DataRecorder dataRecorder = null;
        if (metricName == null) {
            throw new IllegalMetricNameException(kNullMetricNameNotAllowedMessage);
        }
        try {
            dataRecorder = (DataRecorder)fMetricNameToDataRecorderMap.get(metricName);
            creator.IDataRecorderCreator_checkCast(dataRecorder);
            if (dataRecorder != null && dataRecorder.isRemoved()) {
                dataRecorder = null;
            }
        }
        catch (ClassCastException cce) {
            throw new MetricNameAlreadyInUseException(MessageFormat.format(kMetricNameAlreadyInUseMessage, metricName));
        }
        if (dataRecorder == null) {
            try {
                dataRecorder = creator.IDataRecorderCreator_createDataRecorder(metricName);
            }
            catch (BadlyFormedNameException bfne) {
                throw new ImproperlyFormattedMetricNameException(bfne.getMessage());
            }
            catch (ConflictingTypesException cte) {
                throw new MetricNameAlreadyInUseException(cte.getMessage());
            }
            catch (AgentNotAvailableException anae) {
                dataRecorder = new DummyDataRecorder(metricName);
            }
            fMetricNameToDataRecorderMap.put(metricName, dataRecorder);
        }
        return dataRecorder;
    }

    public static DataRecorder createDataRecorderForType(String type, String metricName) throws IllegalMetricNameException, IllegalMetricTypeException {
        if (null == type) {
            throw new IllegalMetricTypeException("null");
        }
        DataRecorderCreator creator = (DataRecorderCreator)sCreatorHash.get(type.toLowerCase());
        if (null == creator) {
            throw new IllegalMetricTypeException(type);
        }
        return creator.create(metricName);
    }

    static {
        sCreatorHash.put(kLongAverageDataRecorderType.toLowerCase(), new DataRecorderCreator(){

            @Override
            public DataRecorder create(String name) throws IllegalMetricNameException {
                return DataRecorderFactory.createLongAverageDataRecorder(name);
            }
        });
        sCreatorHash.put(kIntAverageDataRecorderType.toLowerCase(), new DataRecorderCreator(){

            @Override
            public DataRecorder create(String name) throws IllegalMetricNameException {
                return DataRecorderFactory.createIntAverageDataRecorder(name);
            }
        });
        sCreatorHash.put(kLongCounterDataRecorderType.toLowerCase(), new DataRecorderCreator(){

            @Override
            public DataRecorder create(String name) throws IllegalMetricNameException {
                return DataRecorderFactory.createLongCounterDataRecorder(name);
            }
        });
        sCreatorHash.put(kIntCounterDataRecorderType.toLowerCase(), new DataRecorderCreator(){

            @Override
            public DataRecorder create(String name) throws IllegalMetricNameException {
                return DataRecorderFactory.createIntCounterDataRecorder(name);
            }
        });
        sCreatorHash.put(kIntRateDataRecorderType.toLowerCase(), new DataRecorderCreator(){

            @Override
            public DataRecorder create(String name) throws IllegalMetricNameException {
                return DataRecorderFactory.createIntRateDataRecorder(name);
            }
        });
        sCreatorHash.put(kStringEventDataRecorderType.toLowerCase(), new DataRecorderCreator(){

            @Override
            public DataRecorder create(String name) throws IllegalMetricNameException {
                return DataRecorderFactory.createStringEventDataRecorder(name);
            }
        });
        sCreatorHash.put(kTimestampDataRecorderType.toLowerCase(), new DataRecorderCreator(){

            @Override
            public DataRecorder create(String name) throws IllegalMetricNameException {
                return DataRecorderFactory.createTimestampDataRecorder(name);
            }
        });
        sCreatorHash.put(kPerIntervalDataRecorderType.toLowerCase(), new DataRecorderCreator(){

            @Override
            public DataRecorder create(String name) throws IllegalMetricNameException {
                return DataRecorderFactory.createPerIntervalCounterDataRecorder(name);
            }
        });
    }

    private static final class PerIntervalCounterDataRecorderCreator
    implements IDataRecorderCreator {
        private PerIntervalCounterDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            PerIntervalCounterDataRecorder r = (PerIntervalCounterDataRecorder)recorder;
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new PerIntervalCounterDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getLongIntervalCounterDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class TimestampDataRecorderCreator
    implements IDataRecorderCreator {
        private TimestampDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            TimestampDataRecorder r = (TimestampDataRecorder)recorder;
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new TimestampDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getTimestampDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class StringEventDataRecorderCreator
    implements IDataRecorderCreator {
        private StringEventDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            StringEventDataRecorder r = (StringEventDataRecorder)recorder;
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new StringEventDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getStringEveryEventDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class IntRateDataRecorderCreator
    implements IDataRecorderCreator {
        private IntRateDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            IntRateDataRecorder r = (IntRateDataRecorder)recorder;
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new IntRateDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getIntegerRateDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class IntCounterDataRecorderCreator
    implements IDataRecorderCreator {
        private IntCounterDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            IntCounterDataRecorder r = (IntCounterDataRecorder)recorder;
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new IntCounterDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getIntegerFluctuatingCounterDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class LongCounterDataRecorderCreator
    implements IDataRecorderCreator {
        private LongCounterDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            LongCounterDataRecorder r = (LongCounterDataRecorder)recorder;
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new LongCounterDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getLongFluctuatingCounterDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class IntAverageDataRecorderCreator
    implements IDataRecorderCreator {
        private IntAverageDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            IntAverageDataRecorder r = (IntAverageDataRecorder)recorder;
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new IntAverageDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getIntegerAverageDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static final class LongAverageDataRecorderCreator
    implements IDataRecorderCreator {
        private LongAverageDataRecorderCreator() {
        }

        @Override
        public void IDataRecorderCreator_checkCast(DataRecorder recorder) throws ClassCastException {
            LongAverageDataRecorder r = (LongAverageDataRecorder)recorder;
        }

        @Override
        public DataRecorder IDataRecorderCreator_createDataRecorder(String metricName) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException {
            return new LongAverageDataRecorderImpl(DataRecorderFactory.getDataAccumulatorFactory().getLongAverageDataAccumulator(metricName), DataRecorderFactory.getMetricRecordingAdministrator());
        }
    }

    private static interface IDataRecorderCreator {
        public void IDataRecorderCreator_checkCast(DataRecorder var1) throws ClassCastException;

        public DataRecorder IDataRecorderCreator_createDataRecorder(String var1) throws BadlyFormedNameException, ConflictingTypesException, AgentNotAvailableException;
    }

    private static interface DataRecorderCreator {
        public DataRecorder create(String var1) throws IllegalMetricNameException;
    }
}

