/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.ArfException;
import com.wily.introscope.agent.arf.ArfMessage;
import com.wily.introscope.agent.arf.ArfMessageFactory;
import com.wily.introscope.agent.arf.ArfMessageStatus;
import com.wily.introscope.agent.arf.IArfMessageListener;
import com.wily.util.adt.IConcurrentBlockingQueue;
import com.wily.util.adt.IConcurrentLinkedQueueFactory;
import com.wily.util.adt.IConcurrentQueue;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;

public abstract class AArfConnection {
    protected IArfMessageListener fListener = null;
    protected final boolean bIsClient;
    protected volatile boolean bIsClosed = false;
    protected Thread fReadThread = null;
    protected Thread fWriteThread = null;
    protected final IConcurrentBlockingQueue fQueue;
    protected final IConcurrentQueue fHiPriQueue;
    protected String fHost = null;
    protected String fIpAddr = null;
    protected String fProgram = null;
    protected String fApp = null;
    protected String fProbe = null;
    protected String fInstanceId = null;
    protected String fContainerId = null;
    protected String fPid = null;
    protected String fTid = null;
    protected String fContainerName = null;
    protected String fPodName = null;
    protected String fPodNamespace = null;
    protected String fPodIpAddress = null;
    protected final IModuleFeedbackChannel fFeedback;
    protected final Module kModule = new Module("ArfConnection");

    public AArfConnection(IAgent agent, String connectMsg) throws ArfException {
        this.bIsClient = false;
        this.fFeedback = agent.IAgent_getModuleFeedback();
        IConcurrentLinkedQueueFactory factory = agent.IAgent_getConcurrentLinkedQueueFactory();
        this.fQueue = factory.getConcurrentBlockingQueueSingleConsumer();
        this.fHiPriQueue = factory.getConcurrentQueue();
    }

    public AArfConnection(IAgent agent) {
        this.fFeedback = agent.IAgent_getModuleFeedback();
        IConcurrentLinkedQueueFactory factory = agent.IAgent_getConcurrentLinkedQueueFactory();
        this.fQueue = factory.getConcurrentBlockingQueueSingleConsumer();
        this.fHiPriQueue = factory.getConcurrentQueue();
        this.bIsClient = true;
    }

    public boolean isClient() {
        return this.bIsClient;
    }

    public String getProgram() {
        return this.fProgram;
    }

    public String getProbe() {
        return this.fProbe;
    }

    public String getInstanceId() {
        return this.fInstanceId;
    }

    public String getContainerId() {
        return this.fContainerId;
    }

    public String getPid() {
        return this.fPid;
    }

    public String getTid() {
        return this.fTid;
    }

    public String getHost() {
        return this.fHost;
    }

    public String getAppName() {
        return this.fApp;
    }

    public String getContainerName() {
        return this.fContainerName;
    }

    public String getPodName() {
        return this.fPodName;
    }

    public String getPodNamespace() {
        return this.fPodNamespace;
    }

    public String getPodIpAddress() {
        return this.fPodIpAddress;
    }

    public String getIpAddr() {
        return this.fIpAddr;
    }

    public void start() {
        this.createReader();
        this.createWriter();
    }

    protected abstract void closeConnection();

    public void close() {
        this.fFeedback.debug(this.kModule, "Closing ARF connection: " + this.toString());
        this.bIsClosed = true;
        if (this.fReadThread != null) {
            this.fReadThread.interrupt();
        }
        if (this.fWriteThread != null) {
            this.fWriteThread.interrupt();
        }
        if (this.fListener != null) {
            this.fListener.resetConnection(this);
        }
        this.closeConnection();
    }

    private void createReader() {
        this.fReadThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AArfConnection.this.runReader();
            }
        }, this.toString() + " Reader");
        this.fReadThread.start();
    }

    private void createWriter() {
        this.fWriteThread = new Thread(new Runnable(){

            @Override
            public void run() {
                AArfConnection.this.runWriter();
            }
        }, this.toString() + "Writer");
        this.fWriteThread.start();
    }

    public void setListener(IArfMessageListener listener) {
        this.fListener = listener;
    }

    protected abstract String waitForNextMessage();

    protected abstract void writeToTransport(String var1);

    protected abstract ArfMessageStatus processMessage(ArfMessage var1);

    private void runReader() {
        while (!this.bIsClosed) {
            String message = this.waitForNextMessage();
            ArfMessage m = null;
            if (message == null) {
                this.fFeedback.debug(this.kModule, "End of ARF connection: " + this.toString());
                this.close();
                return;
            }
            if (message.length() == 0) continue;
            try {
                block9: {
                    try {
                        m = ArfMessageFactory.getParserInstance().parseMessage(message);
                    }
                    catch (ArfException e) {
                        if (this.fListener != null) {
                            this.fListener.processMessageError(this, message, e);
                            continue;
                        }
                    }
                    catch (Exception e) {
                        if (this.fListener == null) break block9;
                        this.fListener.processMessageError(this, message, new ArfException("Exception while parsing message", e));
                        continue;
                    }
                }
                if ((m.getOp() == null || m.getOp().length() == 0) && this.fListener != null) {
                    this.fListener.processMessageError(this, message, new ArfException("Received message with no operation defined."));
                    continue;
                }
                this.processMessage(m);
            }
            catch (Exception e) {
                if (this.fListener == null) continue;
                this.fListener.processMessageError(this, message, new ArfException("Exception while processing message", e));
            }
        }
    }

    private void checkHighPriorityQueue() {
        String message = (String)this.fHiPriQueue.poll();
        while (message != null) {
            this.writeToTransport(message);
            message = (String)this.fHiPriQueue.poll();
        }
    }

    private void runWriter() {
        while (!this.bIsClosed) {
            String message = (String)this.fQueue.take();
            this.checkHighPriorityQueue();
            if (message != null) {
                if (message.length() <= 0) continue;
                this.writeToTransport(message);
                continue;
            }
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void send(String message) {
        this.fQueue.put(message);
    }

    public void sendNow(String message) {
        this.fHiPriQueue.offer(message);
        this.fQueue.put("");
    }

    public String toString() {
        return "ArfConnection " + (this.isClient() ? "Client" : "Server");
    }

    public boolean isClosed() {
        return this.bIsClosed;
    }
}

