/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.AArfConnection;
import com.wily.introscope.agent.arf.ArfMessage;
import com.wily.introscope.agent.arf.ArfMessageFactory;
import com.wily.introscope.agent.arf.ArfMessageStatus;
import java.util.HashMap;

public abstract class ArfDataConnection
extends AArfConnection {
    private long fCurrentSequence = 0L;
    private HashMap<String, Long> fTidSeqMap = null;

    public ArfDataConnection(IAgent agent, String connectMessage) throws Exception {
        super(agent, connectMessage);
        ArfMessage m = ArfMessageFactory.getParserInstance().parseMessage(connectMessage);
        if (m.isInstIdSet()) {
            this.fInstanceId = m.getInstId();
        }
        if (m.isProgramSet()) {
            this.fProgram = m.getProgram();
        }
        if (m.isProbeSet()) {
            this.fProbe = m.getProbe();
        }
        if (m.isPidSet()) {
            this.fPid = m.getPid();
        }
        if (m.isTidSet()) {
            this.fTid = m.getTid();
        }
        if (m.isSeqSet()) {
            this.fCurrentSequence = m.getSeq();
        }
    }

    public ArfDataConnection(IAgent agent) {
        super(agent);
    }

    @Override
    protected void closeConnection() {
        if (this.fTidSeqMap != null) {
            this.fTidSeqMap.clear();
        }
    }

    @Override
    protected ArfMessageStatus processMessage(ArfMessage m) {
        if (m.isSeqSet()) {
            boolean tidSet = false;
            String tid = null;
            long seq = m.getSeq();
            if (m.isTidSet() && (tid = m.getTid()) != null && tid.length() > 0) {
                tidSet = true;
                if (this.fTidSeqMap == null) {
                    this.fTidSeqMap = new HashMap();
                } else if (this.fTidSeqMap.containsKey(tid)) {
                    this.fCurrentSequence = this.fTidSeqMap.get(tid);
                }
            }
            if (this.fCurrentSequence != 0L && seq != 0L && seq != this.fCurrentSequence + 1L && this.fListener != null) {
                this.fListener.resetConnection(this);
            }
            if (tidSet && seq != 0L) {
                this.fTidSeqMap.put(this.fTid, seq);
            } else {
                this.fCurrentSequence = seq;
            }
        }
        if (this.fListener != null) {
            return this.fListener.processMessage(this, m);
        }
        return ArfMessageStatus.MSG_FAILED;
    }

    @Override
    public String toString() {
        return "ArfDataConnection " + (this.isClient() ? "Client" : "Server");
    }
}

