/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.arf.ArfDataConnection;
import com.wily.introscope.agent.arf.ArfException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.Socket;

public class TcpArfDataConnection
extends ArfDataConnection {
    private PrintWriter fOut;
    private BufferedReader fIn;
    private Socket fSocket;
    private int fPort = 0;

    public TcpArfDataConnection(IAgent agent, Socket socket, BufferedReader input, String connectMessage) throws Exception {
        super(agent, connectMessage);
        this.fSocket = socket;
        this.fOut = new PrintWriter(socket.getOutputStream(), true);
        this.fIn = input;
        this.fPort = this.fSocket.getPort();
        if (this.fIn == null) {
            this.fIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        }
    }

    public TcpArfDataConnection(IAgent agent, Socket socket) throws IOException {
        super(agent);
        this.fOut = new PrintWriter(socket.getOutputStream(), true);
        this.fIn = new BufferedReader(new InputStreamReader(socket.getInputStream()));
        this.fPort = socket.getPort();
    }

    @Override
    protected void writeToTransport(String message) {
        if (this.fOut != null) {
            this.fOut.println(message);
        }
    }

    protected boolean pingConnection() {
        return false;
    }

    protected void pingResponse() {
    }

    @Override
    protected String waitForNextMessage() {
        try {
            return this.fIn.readLine();
        }
        catch (IOException e) {
            if ("Connection reset".equals(e.getMessage())) {
                this.fFeedback.error(this.kModule, "ARF Connection socket closed:" + this.toString());
            } else {
                if (this.fListener != null) {
                    this.fListener.processMessageError(this, null, new ArfException(e.getMessage()));
                }
                this.fFeedback.error(this.kModule, "Failed to read from ARF connection: " + e.getMessage());
                this.fFeedback.debug(this.kModule, "readline(): ", e);
            }
            this.close();
            return null;
        }
    }

    @Override
    public String toString() {
        return "TcpArfDataConnection type:" + this.fProbe + " instance: " + this.fInstanceId + " port:" + this.fPort;
    }

    @Override
    protected void closeConnection() {
        super.closeConnection();
        try {
            if (this.fOut != null) {
                this.fOut.close();
            }
            if (this.fSocket != null) {
                this.fSocket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.fIn = null;
        this.fOut = null;
        this.fSocket = null;
    }
}

