/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.arf.internal;

import com.wily.introscope.agent.arf.ArfMap;
import java.util.ArrayList;
import java.util.Map;

public class ArfWriter {
    final ArrayList fWriters = new ArrayList(12);

    public void addWriterEntry(String name, IWriter writer) {
        this.fWriters.add(new ArfWriterEntry(name, writer));
    }

    public void clearEntries() {
        this.fWriters.clear();
    }

    public String write(Object o) {
        StringBuffer b = new StringBuffer();
        b.append('{');
        for (ArfWriterEntry e : this.fWriters) {
            e.fWriter.write(o, b);
        }
        b.append('}');
        return b.toString();
    }

    public String writeMap(Map m) {
        StringBuffer b = new StringBuffer();
        b.append('{');
        for (Map.Entry e : m.entrySet()) {
            if (e.getValue() instanceof String) {
                ArfWriter.writeStringParam(b, e.getKey().toString(), (String)e.getValue());
            } else if (e.getValue() instanceof Integer) {
                ArfWriter.writeIntParam(b, e.getKey().toString(), (Integer)e.getValue());
            } else if (e.getValue() instanceof Long) {
                ArfWriter.writeLongParam(b, e.getKey().toString(), (Long)e.getValue());
            }
            if (e.getValue() instanceof Boolean) {
                ArfWriter.writeBooleanParam(b, e.getKey().toString(), (Boolean)e.getValue());
                continue;
            }
            if (!(e.getValue() instanceof ArfMap)) continue;
            ArfWriter.writeObjectParam(b, e.getKey().toString(), ((ArfMap)e.getValue()).toString());
        }
        b.append('}');
        return b.toString();
    }

    private static StringBuffer handleFirstField(StringBuffer b) {
        if (b.charAt(b.length() - 1) != '{') {
            b.append(',');
        }
        return b;
    }

    public static StringBuffer writeStringParam(StringBuffer b, String name, String value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":\"");
        b.append(value);
        b.append('\"');
        return b;
    }

    public static StringBuffer writeObjectParam(StringBuffer b, String name, String value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":");
        b.append(value);
        return b;
    }

    public static StringBuffer writeIntParam(StringBuffer b, String name, int value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":");
        b.append(value);
        return b;
    }

    public static StringBuffer writeLongParam(StringBuffer b, String name, long value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":");
        b.append(value);
        return b;
    }

    public static StringBuffer writeBooleanParam(StringBuffer b, String name, Boolean value) {
        ArfWriter.handleFirstField(b);
        b.append('\"');
        b.append(name);
        b.append("\":");
        b.append(value);
        return b;
    }

    public static interface IWriter {
        public void write(Object var1, StringBuffer var2);
    }

    public static class ArfWriterEntry {
        String fName;
        IWriter fWriter;

        public ArfWriterEntry(String name, IWriter writer) {
            this.fName = name;
            this.fWriter = writer;
        }
    }
}

