/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.collector;

import com.wily.introscope.agent.collector.CollectorAgent;
import java.net.URL;
import java.util.jar.Manifest;

public enum CollectorAgentInfo {
    INSTANCE;

    private String version = CollectorAgentInfo.retrieveInfoFromManifest("com-wily-Release");

    public String getVersion() {
        return this.version;
    }

    private static String retrieveInfoFromManifest(String key) {
        String fileName = CollectorAgentInfo.getManifestUrl();
        if (fileName != null) {
            try {
                Manifest manifest = new Manifest(new URL(fileName).openStream());
                return manifest.getMainAttributes().getValue(key);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return "Unknown";
    }

    private static String getManifestUrl() {
        int marker;
        String manifestUrlString = null;
        Class<CollectorAgent> clazz = CollectorAgent.class;
        String classFileName = "/" + clazz.getName().replace('.', '/') + ".class";
        URL url = clazz.getResource(classFileName);
        String urlString = url.toString();
        if (urlString.startsWith("jar:") && (marker = urlString.indexOf("!")) != -1) {
            manifestUrlString = urlString.substring(0, marker + 1) + "/META-INF/MANIFEST.MF";
        }
        return manifestUrlString;
    }
}

