/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.collector;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.collector.ProbeCollector;
import com.wily.introscope.agent.collector.ProbeManager;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.InstantiableDynamicClassLookup;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;

final class ProbeCollectorLoader
extends InstantiableDynamicClassLookup {
    private static final String kProbeCollectorPluginType = "probecollector";
    private static final String kPluginProbeTypeAttributeKey = "Probe-Type";
    private static final int kCurrentProbeCollectorPluginVersion = 1;
    private static final Class[] kProbeCollectorConstructorParameterTypes = new Class[]{IAgent.class, ProbeManager.class};
    private IValidationFeedbackChannel fValidationFeedbackChannel;
    private final ProbeManager fManager;

    public ProbeCollectorLoader(IAgent agent, ProbeManager manager) {
        super(agent, ProbeCollector.class, kProbeCollectorConstructorParameterTypes);
        if (AInstrumentationHelper.isValidate()) {
            this.fValidationFeedbackChannel = AInstrumentationHelper.getValidationFeedbackChannel();
        }
        this.fManager = manager;
        this.loadProbeCollectorPlugins();
    }

    @Override
    protected Object[] getConstructorParameters(IAgent dynamicAgent) {
        return new Object[]{dynamicAgent, this.fManager};
    }

    public ProbeCollector loadProbeCollector(String probeType) {
        return (ProbeCollector)this.load(probeType);
    }

    private void loadProbeCollectorPlugins() {
        ExtensionAdministrator extensionAdministrator = this.getAgent().IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kProbeCollectorPluginType);
        for (int i = 0; i < plugins.length; ++i) {
            this.loadProbeCollectorPlugin(plugins[i]);
        }
        extensionAdministrator.setGlobalPluginCallbackByType(kProbeCollectorPluginType, new IPlugin.IPluginCallback(){

            @Override
            public void onUnload(IPlugin p) {
            }

            @Override
            public void onLoad(IPlugin p) {
                ProbeCollectorLoader.this.loadProbeCollectorPlugin(p);
            }
        });
    }

    private void loadProbeCollectorPlugin(IPlugin plugin) {
        Class probeCollectorClass = ExtensionUtilities.loadEntryPointClass(this.getModuleFeedback(), this.getStringLocalizer(), plugin, 1, ProbeCollector.class, this.fValidationFeedbackChannel);
        if (probeCollectorClass != null) {
            IStringLocalizer probeCollectorLocalizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.getStringLocalizer());
            try {
                this.register(plugin, plugin.IPlugin_getAttributes().getValue(kPluginProbeTypeAttributeKey), probeCollectorClass, probeCollectorLocalizer);
                this.getModuleFeedback().verbose("Registered new ProbeCollector from " + plugin.IPlugin_getOwningExtension().IExtension_getName() + " named " + plugin.IPlugin_getName());
            }
            catch (DuplicateDynamicClassException ddce) {
                String errorMessage = "Dublipcate probe collector plugin class from " + plugin.IPlugin_getOwningExtension().IExtension_getSource() + " extension " + plugin.IPlugin_getOwningExtension().IExtension_getName() + " name " + plugin.IPlugin_getName();
                this.logErrorValidationFeedback(errorMessage, ddce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(ddce);
            }
            catch (InvalidDynamicClassException idce) {
                String errorMessage = "Invalid probe collector plugin class from " + plugin.IPlugin_getOwningExtension().IExtension_getSource() + " extension " + plugin.IPlugin_getOwningExtension().IExtension_getName() + " name " + plugin.IPlugin_getName();
                this.logErrorValidationFeedback(errorMessage, idce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(idce);
            }
        }
    }

    private void logErrorValidationFeedback(String message, Throwable cause) {
        if (this.fValidationFeedbackChannel != null) {
            this.fValidationFeedbackChannel.error(message, cause);
        }
    }
}

